/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.controlbus.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

@QuarkusTest
class ControlbusTest {
    ControlbusTest() {
    }

    @BeforeEach
    public void startRoute() {
        String status = RestAssured.get((String)"/controlbus/status", (Object[])new Object[0]).asString();
        if ("Stopped".equals(status)) {
            RestAssured.get((String)"/controlbus/start", (Object[])new Object[0]);
        }
    }

    @Test
    public void testStopStart() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/controlbus/status", new Object[0])).then()).body(CoreMatchers.equalTo((Object)"Started"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/controlbus/stop", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/controlbus/status", new Object[0])).then()).body(CoreMatchers.equalTo((Object)"Stopped"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/controlbus/start", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/controlbus/status", new Object[0])).then()).body(CoreMatchers.equalTo((Object)"Started"), new Matcher[0]);
    }

    @Test
    public void testSuspendResume() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/controlbus/status", new Object[0])).then()).body(CoreMatchers.equalTo((Object)"Started"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/controlbus/suspend", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/controlbus/status", new Object[0])).then()).body(CoreMatchers.equalTo((Object)"Suspended"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/controlbus/resume", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/controlbus/status", new Object[0])).then()).body(CoreMatchers.equalTo((Object)"Started"), new Matcher[0]);
    }

    @Test
    public void testFail() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/controlbus/status", new Object[0])).then()).body(CoreMatchers.equalTo((Object)"Started"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/controlbus/fail", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/controlbus/status", new Object[0])).then()).body(CoreMatchers.equalTo((Object)"Stopped"), new Matcher[0]);
    }

    @Test
    public void testRestart() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/controlbus/status", new Object[0])).then()).body(CoreMatchers.equalTo((Object)"Started"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/controlbus/restart", new Object[0])).then()).body("startCount", CoreMatchers.equalTo((Object)1), new Object[0])).body("stopCount", CoreMatchers.equalTo((Object)1), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/controlbus/status", new Object[0])).then()).body(CoreMatchers.equalTo((Object)"Started"), new Matcher[0]);
    }
}

