/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.controlbus.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
class ControlbusLanguageTest {
    ControlbusLanguageTest() {
    }

    @BeforeEach
    public void startRoute() {
        String status = RestAssured.get((String)"/controlbus/language/status", (Object[])new Object[0]).asString();
        if ("Stopped".equals(status)) {
            RestAssured.post((String)"/controlbus/language/start", (Object[])new Object[0]);
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"simple", "bean", "header", "exchangeProperty"})
    public void testLanguage(String language) {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/controlbus/language/status", new Object[0])).then()).body(CoreMatchers.equalTo((Object)"Started"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).post("/controlbus/language/" + language, new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/controlbus/language/status", new Object[0])).then()).body(CoreMatchers.equalTo((Object)"Stopped"), new Matcher[0]);
    }
}

