/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.compression.it;

import java.net.URI;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;

@Path(value="/compression")
@ApplicationScoped
public class CompressionResource {
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/compress/{format}")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/octet-stream"})
    public Response zipfileCompress(@PathParam(value="format") String format, byte[] message) throws Exception {
        byte[] response = (byte[])this.producerTemplate.requestBody("direct:" + format + "-compress", (Object)message, byte[].class);
        return Response.created((URI)new URI("https://camel.apache.org/")).header("content-length", (Object)response.length).entity((Object)response).build();
    }

    @Path(value="/uncompress/{format}")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/octet-stream"})
    public Response zipfileUncompress(@PathParam(value="format") String format, byte[] message) throws Exception {
        byte[] response = (byte[])this.producerTemplate.requestBody("direct:" + format + "-uncompress", (Object)message, byte[].class);
        return Response.created((URI)new URI("https://camel.apache.org/")).header("content-length", (Object)response.length).entity((Object)response).build();
    }
}

