/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.compression.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@QuarkusTest
class CompressionTest {
    final byte[] UNCOMPRESSED = "Hello World!".getBytes(StandardCharsets.UTF_8);

    CompressionTest() {
    }

    private static Stream<String> listJsonDataFormatsToBeTested() {
        return Stream.of("zipfile", "zip-deflater", "gzip-deflater", "lzf");
    }

    @ParameterizedTest
    @MethodSource(value={"listJsonDataFormatsToBeTested"})
    public void compressAndUncompress(String format) throws Exception {
        byte[] compressed = ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.BINARY).body(this.UNCOMPRESSED).post("/compression/compress/" + format, new Object[0])).then()).extract().body().asByteArray();
        Assertions.assertNotNull((Object)compressed);
        byte[] uncompressed = ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.BINARY).body(compressed).post("/compression/uncompress/" + format, new Object[0])).then()).extract().body().asByteArray();
        Assertions.assertArrayEquals((byte[])this.UNCOMPRESSED, (byte[])uncompressed);
    }
}

