/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.cbor.it;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.camel.quarkus.component.cbor.it.model.Author;
import org.apache.camel.quarkus.component.cbor.it.model.DummyObject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class CborTest {
    private static final ObjectMapper CBOR_MAPPER = new ObjectMapper((JsonFactory)new CBORFactory());

    CborTest() {
    }

    @Test
    void marshalUnmarshalMapShouldSucceed() {
        Map<String, String> in = Collections.singletonMap("name", "Camel");
        String uri = "/cbor/marshalUnmarshalMap";
        Map out = (Map)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(in).get(uri, new Object[0])).then()).statusCode(200)).extract().as(Map.class);
        Assertions.assertEquals((int)1, (int)out.size());
    }

    @Test
    void marshalUnmarshalAuthorShouldSucceed() {
        Author in = new Author();
        in.setName("Don");
        in.setSurname("Winslow");
        String uri = "/cbor/marshalUnmarshalAuthor";
        Author out = (Author)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)in).get(uri, new Object[0])).then()).statusCode(200)).extract().as(Author.class);
        Assertions.assertEquals((Object)"Don", (Object)out.getName());
        Assertions.assertEquals((Object)"Winslow", (Object)out.getSurname());
    }

    @Test
    void marshalUnmarshalCborMethod() {
        Author in = new Author();
        in.setName("Joe");
        in.setSurname("Doe");
        String uri = "/cbor/marshalUnmarshalCborMethod";
        Author out = (Author)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)in).get(uri, new Object[0])).then()).statusCode(200)).extract().as(Author.class);
        Assertions.assertEquals((Object)"Joe", (Object)out.getName());
        Assertions.assertEquals((Object)"Doe", (Object)out.getSurname());
    }

    @Test
    void unmarshalAuthorViaJmsTypeHeaderShouldSucceed() throws JsonProcessingException {
        Author author = new Author();
        author.setName("David");
        author.setSurname("Foster Wallace");
        byte[] authorCborBytes = CBOR_MAPPER.writeValueAsBytes((Object)author);
        String uri = "/cbor/unmarshalAuthorViaJmsTypeHeader";
        Author unmarshalled = (Author)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(authorCborBytes).get(uri, new Object[0])).then()).statusCode(200)).extract().as(Author.class);
        Assertions.assertNotNull((Object)unmarshalled);
        Assertions.assertEquals((Object)"David", (Object)unmarshalled.getName());
        Assertions.assertEquals((Object)"Foster Wallace", (Object)unmarshalled.getSurname());
    }

    @Test
    void unmarshalDummyObjectListShouldSucceed() throws JsonProcessingException {
        DummyObject first = new DummyObject();
        first.setDummy("value1");
        DummyObject second = new DummyObject();
        second.setDummy("value2");
        byte[] listCborBytes = CBOR_MAPPER.writeValueAsBytes(Arrays.asList(first, second));
        String uri = "/cbor/unmarshalDummyObjectList";
        DummyObject[] objects = (DummyObject[])((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().body(listCborBytes).get(uri, new Object[0])).then()).statusCode(200)).extract().as(DummyObject[].class);
        Assertions.assertEquals((int)2, (int)objects.length);
    }
}

