/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.cassandraql.it;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.quarkus.runtime.api.session.QuarkusCqlSession;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.BindToRegistry;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.aggregate.cassandra.NamedCassandraAggregationRepository;
import org.apache.camel.processor.idempotent.cassandra.NamedCassandraIdempotentRepository;
import org.apache.camel.quarkus.component.cassandraql.it.CustomLoadBalancingPolicy;
import org.apache.camel.quarkus.component.cassandraql.it.Employee;
import org.apache.camel.spi.AggregationRepository;
import org.apache.camel.spi.IdempotentRepository;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class CassandraqlRoutes
extends RouteBuilder {
    public static final String KEYSPACE = "test";
    @ConfigProperty(name="quarkus.cassandra.contact-points")
    String dbUrl;
    @ConfigProperty(name="quarkus.cassandra.auth.username")
    String userName;
    @ConfigProperty(name="quarkus.cassandra.auth.password")
    String password;
    @Inject
    @BindToRegistry(value="quarkusCqlSession")
    QuarkusCqlSession session;

    public void configure() throws Exception {
        this.from("direct:create").toF("cql://%s/%s?username=%s&password=%s&cql=INSERT INTO employee (id, name, address) VALUES (?, ?, ?)", new Object[]{this.dbUrl, KEYSPACE, this.userName, this.password});
        this.from("direct:createIdempotent").idempotentConsumer((Expression)this.simple("${body[0]}"), (IdempotentRepository)new NamedCassandraIdempotentRepository((CqlSession)this.session, "ID")).toF("cql://%s/%s?username=%s&password=%s&cql=INSERT INTO employee (id, name, address) VALUES (?, ?, ?)", new Object[]{this.dbUrl, KEYSPACE, this.userName, this.password});
        this.from("direct:createCustomSession").toF("cql:bean:customCqlSession?cql=INSERT INTO employee (id, name, address) VALUES (?, ?, ?)", new Object[0]);
        this.from("direct:createQuarkusSession").to("cql:bean:quarkusCqlSession?cql=INSERT INTO employee (id, name, address) VALUES (?, ?, ?)");
        this.from("direct:createCustomLoadBalancingPolicy").toF("cql://%s/%s?username=%s&password=%s&loadBalancingPolicyClass=%s&cql=INSERT INTO employee (id, name, address) VALUES (?, ?, ?)", new Object[]{this.dbUrl, KEYSPACE, this.userName, this.password, CustomLoadBalancingPolicy.class.getName()});
        this.from("direct:read").toF("cql://%s/%s?username=%s&password=%s&cql=SELECT * FROM employee WHERE id = ?", new Object[]{this.dbUrl, KEYSPACE, this.userName, this.password});
        this.from("direct:update").toF("cql://%s/%s?username=%s&password=%s&cql=UPDATE employee SET name = ?, address = ? WHERE id = ?", new Object[]{this.dbUrl, KEYSPACE, this.userName, this.password});
        this.from("direct:delete").toF("cql://%s/%s?username=%s&password=%s&cql=DELETE FROM employee WHERE id = ?", new Object[]{this.dbUrl, KEYSPACE, this.userName, this.password});
        ((RouteDefinition)this.fromF("cql://%s/%s?username=%s&password=%s&repeatCount=1&cql=SELECT * FROM employee", new Object[]{this.dbUrl, KEYSPACE, this.userName, this.password}).id("employee-consumer")).autoStartup(false).to("seda:employees");
        this.from("direct:aggregate").aggregate((Expression)this.simple("${body.id}"), this.createAggregationStrategy()).completionSize(3).completionTimeout(5000L).aggregationRepository(this.createAggregationRepository()).to("seda:employees");
        this.from("direct:readWithCustomStrategy").toF("cql://%s/%s?username=%s&password=%s&resultSetConversionStrategy=#customResultSetConversionStrategy&cql=SELECT * FROM employee WHERE id = ?", new Object[]{this.dbUrl, KEYSPACE, this.userName, this.password});
        this.from("direct:cqlHeaderQuery").toF("cql://%s/%s?username=%s&password=%s", new Object[]{this.dbUrl, KEYSPACE, this.userName, this.password});
    }

    private AggregationStrategy createAggregationStrategy() {
        return (oldExchange, newExchange) -> {
            if (oldExchange == null) {
                return newExchange;
            }
            Employee newBody = (Employee)newExchange.getMessage().getBody(Employee.class);
            Object oldBody = oldExchange.getMessage().getBody();
            String newName = null;
            if (oldBody instanceof Employee) {
                newName = ((Employee)oldBody).getName() + "," + newBody.getName();
            } else if (oldBody instanceof String) {
                newName = String.valueOf(oldBody) + "," + newBody.getName();
            }
            oldExchange.getMessage().setBody((Object)newName);
            return oldExchange;
        };
    }

    private AggregationRepository createAggregationRepository() {
        NamedCassandraAggregationRepository repository = new NamedCassandraAggregationRepository();
        repository.setSession((CqlSession)this.session);
        return repository;
    }
}

