/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.cassandraql.it;

import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatementBuilder;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Exchange;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.quarkus.component.cassandraql.it.CustomLoadBalancingPolicy;
import org.apache.camel.quarkus.component.cassandraql.it.Employee;

@Path(value="/cassandraql")
@ApplicationScoped
public class CassandraqlResource {
    public static final String EMPTY_LIST = "EMPTY";
    @Inject
    CamelContext camelContext;
    @Inject
    FluentProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    @Path(value="/insertEmployee")
    @POST
    public void insertEmployee(@QueryParam(value="name") String name, @QueryParam(value="address") String address, @QueryParam(value="id") int id, @QueryParam(value="endpointUri") String endpointUri) {
        this.producerTemplate.to(endpointUri).withBody(new Employee(id, name, address).getValueForInsert()).request();
    }

    @Path(value="/getEmployee")
    @GET
    @Produces(value={"text/plain"})
    public String getEmployee(@QueryParam(value="id") int id) {
        List rows = (List)this.producerTemplate.to("direct:read").withBody((Object)id).request(List.class);
        return this.convertBodyToString(rows);
    }

    @Path(value="/cqlHeaderQuery")
    @GET
    @Produces(value={"text/plain"})
    public String cqlHeaderQuery(@QueryParam(value="id") int id, @QueryParam(value="cql") String cql, @QueryParam(value="queryAsSimpleStatement") boolean queryAsSimpleStatement) {
        String cqlQuery = queryAsSimpleStatement ? new SimpleStatementBuilder(cql).build() : cql;
        List rows = (List)this.producerTemplate.to("direct:cqlHeaderQuery").withHeader("CamelCqlQuery", (Object)cqlQuery).withBody((Object)id).request(List.class);
        return this.convertBodyToString(rows);
    }

    @Path(value="/getEmployeeWithStrategy")
    @GET
    @Produces(value={"text/plain"})
    public String getEmployeeWithStrategy(@QueryParam(value="id") int id) {
        List employees = (List)this.producerTemplate.to("direct:readWithCustomStrategy").withBody((Object)id).request(List.class);
        if (employees.isEmpty()) {
            return "";
        }
        return ((Employee)employees.get(0)).getName();
    }

    @Path(value="/getAllEmployees")
    @GET
    @Produces(value={"text/plain"})
    public String getAllEmployees() throws Exception {
        try {
            this.camelContext.getRouteController().startRoute("employee-consumer");
            Exchange exchange = this.consumerTemplate.receive("seda:employees", 5000L);
            String string = this.convertBodyToString(exchange.getMessage().getBody());
            return string;
        }
        finally {
            this.camelContext.getRouteController().stopRoute("employee-consumer");
        }
    }

    @Path(value="/updateEmployee")
    @PATCH
    @Produces(value={"text/plain"})
    public boolean updateEmployee(@QueryParam(value="name") String name, @QueryParam(value="address") String address, @QueryParam(value="id") int id) {
        Object result = this.producerTemplate.to("direct:update").withBody(new Employee(id, name, address).getValueForUpdate()).request();
        return result != null;
    }

    @Path(value="/deleteEmployeeById")
    @DELETE
    public void deleteEmployeeById(@QueryParam(value="id") int id) {
        this.producerTemplate.to("direct:delete").withBody((Object)id).request();
    }

    @Path(value="/aggregate")
    @POST
    public void aggregate(@QueryParam(value="name") String name, @QueryParam(value="address") String address, @QueryParam(value="id") int id) {
        this.producerTemplate.to("direct:aggregate").withBody((Object)new Employee(id, name, address)).request();
    }

    @Path(value="/checkLoadBalancingPolicy")
    @GET
    @Produces(value={"text/plain"})
    public boolean checkLoadBalancingPolicy() throws Exception {
        return CustomLoadBalancingPolicy.awaitInitialization();
    }

    private String convertBodyToString(Object body) {
        if (body instanceof List) {
            if (((List)body).isEmpty()) {
                return EMPTY_LIST;
            }
            return ((List)body).stream().map(Row::getFormattedContents).collect(Collectors.joining(";"));
        }
        if (body instanceof String) {
            return (String)body;
        }
        return "";
    }
}

