/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.cassandraql.it;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import javax.inject.Named;
import org.apache.camel.component.cassandra.ResultSetConversionStrategy;
import org.apache.camel.quarkus.component.cassandraql.it.Employee;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class CassandraqlProducers {
    @Named
    public CqlSession customCqlSession(@ConfigProperty(name="quarkus.cassandra.auth.username") String username, @ConfigProperty(name="quarkus.cassandra.auth.password") String password, @ConfigProperty(name="quarkus.cassandra.contact-points") String dbUrl) {
        String[] urlParts = dbUrl.split(":");
        CqlSessionBuilder sessionBuilder = CqlSession.builder();
        sessionBuilder.addContactPoint(new InetSocketAddress(urlParts[0], Integer.parseInt(urlParts[1])));
        sessionBuilder.withLocalDatacenter("datacenter1");
        sessionBuilder.withKeyspace("test");
        sessionBuilder.withAuthCredentials(username, password);
        return (CqlSession)sessionBuilder.build();
    }

    @Named
    public ResultSetConversionStrategy customResultSetConversionStrategy() {
        return resultSet -> {
            ArrayList employees = new ArrayList();
            resultSet.forEach(row -> {
                String name = row.getString("name");
                String address = row.getString("address");
                int id = row.getInt("id");
                Employee employee = new Employee(id, name + " modified", address);
                employees.add(employee);
            });
            return employees;
        };
    }
}

