/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.cassandraql.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.cassandraql.it.CassandraqlTestResource;
import org.apache.camel.quarkus.component.cassandraql.it.Employee;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;

@QuarkusTest
@QuarkusTestResource(value=CassandraqlTestResource.class)
@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
class CassandraqlTest {
    private Employee sheldon = new Employee(1, "Sheldon", "Alpha Centauri");
    private Employee leonard = new Employee(2, "Leonard", "Earth");
    private Employee irma = new Employee(3, "Irma", "Jupiter");

    CassandraqlTest() {
    }

    @Test
    @Order(value=1)
    public void testInsert() {
        this.insertEmployee(this.sheldon);
        this.assertEmployee(this.sheldon.getId(), Matchers.containsString((String)this.sheldon.getName()));
        this.insertEmployee(this.leonard);
        this.assertEmployee(this.leonard.getId(), Matchers.containsString((String)this.leonard.getName()));
        this.assertEmployee(this.irma.getId(), Matchers.equalTo((Object)"EMPTY"));
        this.insertEmployee(this.irma);
        this.assertEmployee(this.irma.getId(), Matchers.containsString((String)this.irma.getName()));
    }

    @Test
    @Order(value=2)
    public void testUpdate() throws CloneNotSupportedException {
        Employee updatedSheldon = (Employee)this.sheldon.clone();
        updatedSheldon.setAddress("Earth 2.0");
        this.assertEmployee(this.sheldon.getId(), (Matcher)Matchers.both((Matcher)Matchers.containsString((String)this.sheldon.getAddress())).and(Matchers.not((Matcher)Matchers.containsString((String)updatedSheldon.getAddress()))));
        this.updateEmployee(updatedSheldon);
        this.assertEmployee(this.sheldon.getId(), (Matcher)Matchers.both((Matcher)Matchers.containsString((String)updatedSheldon.getAddress())).and(Matchers.not((Matcher)Matchers.containsString((String)this.sheldon.getAddress()))));
    }

    @Test
    @Order(value=3)
    public void testDelete() {
        this.assertAllEmployees(Matchers.allOf((Matcher)Matchers.containsString((String)this.sheldon.getName()), (Matcher)Matchers.containsString((String)this.leonard.getName()), (Matcher)Matchers.containsString((String)this.irma.getName())));
        this.deleteEmployee(this.sheldon.getId());
        this.deleteEmployee(this.leonard.getId());
        this.assertAllEmployees(Matchers.allOf((Matcher)Matchers.not((Matcher)Matchers.containsString((String)this.sheldon.getName())), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)this.leonard.getName())), (Matcher)Matchers.containsString((String)this.irma.getName())));
        this.deleteEmployee(this.irma.getId());
        this.assertAllEmployees(Matchers.equalTo((Object)"EMPTY"));
    }

    private void assertEmployee(int id, Matcher matcher) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body((Object)id).post("/cassandraql/getEmployee", new Object[0])).then()).statusCode(200)).body(matcher, new Matcher[0]);
    }

    private void assertAllEmployees(Matcher matcher) {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/cassandraql/getAllEmployees", (Object[])new Object[0]).then()).statusCode(200)).body(matcher, new Matcher[0]);
    }

    private void insertEmployee(Employee employee) {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)employee).post("/cassandraql/insertEmployee", new Object[0])).then()).statusCode(204);
    }

    private void updateEmployee(Employee employee) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)employee).post("/cassandraql/updateEmployee", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)String.valueOf(true)), new Matcher[0]);
    }

    private void deleteEmployee(int id) {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body((Object)id).post("/cassandraql/deleteEmployeeById", new Object[0])).then()).statusCode(204);
    }
}

