/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.cassandraql.it;

import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Exchange;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.quarkus.component.cassandraql.it.Employee;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Path(value="/cassandraql")
@ApplicationScoped
public class CassandraqlResource {
    public static final String KEYSPACE = "test";
    public static final String EMPTY_LIST = "EMPTY";
    @Inject
    FluentProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;
    @ConfigProperty(name="db.cassandra.url")
    String dbUrl;

    @Path(value="/insertEmployee")
    @POST
    @Consumes(value={"application/json"})
    public void insertEmployee(Employee object) {
        this.producerTemplate.toF(this.createUrl("INSERT INTO employee(id, name, address) VALUES (?, ?, ?)"), new Object[0]).withBody((Object)object.getValue()).request();
    }

    @Path(value="/getEmployee")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String getEmployee(String id) throws Exception {
        Exchange exchange = this.consumerTemplate.receive(this.createUrl(String.format("SELECT * FROM employee WHERE id = %s", id)));
        return this.convertBodyToString(exchange.getIn().getBody());
    }

    @Path(value="/getAllEmployees")
    @GET
    @Produces(value={"text/plain"})
    public String getAllEmployees() throws Exception {
        Exchange exchange = this.consumerTemplate.receive(this.createUrl("SELECT id, name, address FROM employee"));
        return this.convertBodyToString(exchange.getIn().getBody());
    }

    @Path(value="/updateEmployee")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public boolean updateEmployee(Employee employee) throws Exception {
        Exchange exchange = this.consumerTemplate.receive(this.createUrl(String.format("UPDATE employee SET name = '%s', address = '%s' WHERE id = %s", employee.getName(), employee.getAddress(), employee.getId())));
        return exchange != null;
    }

    @Path(value="/deleteEmployeeById")
    @POST
    @Consumes(value={"text/plain"})
    public void deleteEmplyeeById(String id) throws Exception {
        this.consumerTemplate.receive(this.createUrl(String.format("DELETE FROM employee WHERE id = %s", id)));
    }

    private String createUrl(String cql) {
        return String.format("cql://%s/%s?cql=%s", this.dbUrl, KEYSPACE, cql);
    }

    private String convertBodyToString(Object body) {
        if (body instanceof List) {
            if (((List)body).isEmpty()) {
                return EMPTY_LIST;
            }
            return ((List)body).stream().map(r -> r.getFormattedContents()).collect(Collectors.joining(";"));
        }
        return "";
    }
}

