/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.cassandraql.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.stream.Stream;
import org.apache.camel.quarkus.component.cassandraql.it.CassandraqlTestResource;
import org.apache.camel.quarkus.component.cassandraql.it.Employee;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
@QuarkusTestResource(value=CassandraqlTestResource.class)
class CassandraqlTest {
    private Employee sheldon = new Employee(1, "Sheldon", "Alpha Centauri");
    private Employee leonard = new Employee(2, "Leonard", "Earth");
    private Employee irma = new Employee(3, "Irma", "Jupiter");

    CassandraqlTest() {
    }

    @Test
    public void testCassandraCrudOperations() throws Exception {
        try {
            Stream.of(this.sheldon, this.leonard, this.irma).forEach(employee -> {
                this.insertEmployee((Employee)employee, "direct:create");
                this.assertEmployee(employee.getId(), Matchers.containsString((String)employee.getName()));
            });
            this.assertAllEmployees(Matchers.allOf((Matcher)Matchers.containsString((String)this.sheldon.getName()), (Matcher)Matchers.containsString((String)this.leonard.getName()), (Matcher)Matchers.containsString((String)this.irma.getName())));
            Employee updatedSheldon = (Employee)this.sheldon.clone();
            updatedSheldon.setAddress("Earth 2.0");
            this.assertEmployee(this.sheldon.getId(), (Matcher<?>)Matchers.both((Matcher)Matchers.containsString((String)this.sheldon.getAddress())).and(Matchers.not((Matcher)Matchers.containsString((String)updatedSheldon.getAddress()))));
            this.updateEmployee(updatedSheldon);
            this.assertEmployee(this.sheldon.getId(), (Matcher<?>)Matchers.both((Matcher)Matchers.containsString((String)updatedSheldon.getAddress())).and(Matchers.not((Matcher)Matchers.containsString((String)this.sheldon.getAddress()))));
        }
        catch (Throwable throwable) {
            Stream.of(this.sheldon, this.leonard, this.irma).forEach(employee -> {
                this.deleteEmployee(employee.getId());
                this.assertEmployee(employee.getId(), Matchers.equalTo((Object)"EMPTY"));
            });
            throw throwable;
        }
        Stream.of(this.sheldon, this.leonard, this.irma).forEach(employee -> {
            this.deleteEmployee(employee.getId());
            this.assertEmployee(employee.getId(), Matchers.equalTo((Object)"EMPTY"));
        });
    }

    @Test
    public void customSession() {
        try {
            Stream.of(this.sheldon, this.leonard, this.irma).forEach(employee -> this.insertEmployee((Employee)employee, "direct:createCustomSession"));
            this.assertAllEmployees(Matchers.allOf((Matcher)Matchers.containsString((String)this.sheldon.getName()), (Matcher)Matchers.containsString((String)this.leonard.getName()), (Matcher)Matchers.containsString((String)this.irma.getName())));
        }
        catch (Throwable throwable) {
            Stream.of(this.sheldon, this.leonard, this.irma).forEach(employee -> this.deleteEmployee(employee.getId()));
            throw throwable;
        }
        Stream.of(this.sheldon, this.leonard, this.irma).forEach(employee -> this.deleteEmployee(employee.getId()));
    }

    @Test
    public void quarkusCassandraSession() {
        try {
            Stream.of(this.sheldon, this.leonard, this.irma).forEach(employee -> this.insertEmployee((Employee)employee, "direct:createQuarkusSession"));
            this.assertAllEmployees(Matchers.allOf((Matcher)Matchers.containsString((String)this.sheldon.getName()), (Matcher)Matchers.containsString((String)this.leonard.getName()), (Matcher)Matchers.containsString((String)this.irma.getName())));
        }
        catch (Throwable throwable) {
            Stream.of(this.sheldon, this.leonard, this.irma).forEach(employee -> this.deleteEmployee(employee.getId()));
            throw throwable;
        }
        Stream.of(this.sheldon, this.leonard, this.irma).forEach(employee -> this.deleteEmployee(employee.getId()));
    }

    @Test
    public void idempotent() {
        try {
            for (int i = 0; i < 5; ++i) {
                this.insertEmployee(this.sheldon, "direct:createIdempotent");
            }
            this.assertAllEmployees(Matchers.equalTo((Object)"[id:1, address:'Alpha Centauri', name:'Sheldon']"));
        }
        finally {
            this.deleteEmployee(this.sheldon.getId());
        }
    }

    @Test
    public void aggregate() {
        Stream.of("foo", "bar", "cheese").forEach(name -> {
            Employee employee = new Employee(1, name, name + " address");
            ((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{employee.getId()}).queryParam("name", new Object[]{employee.getName()}).queryParam("address", new Object[]{employee.getAddress()}).post("/cassandraql/aggregate", new Object[0])).then()).statusCode(204);
        });
        this.assertAllEmployees(Matchers.equalTo((Object)"foo,bar,cheese"));
    }

    @Test
    public void resultSetConversionStrategy() {
        try {
            this.insertEmployee(this.sheldon, "direct:create");
            this.assertEmployee(this.sheldon.getId(), Matchers.containsString((String)this.sheldon.getName()));
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{this.sheldon.getId()}).get("/cassandraql/getEmployeeWithStrategy", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)(this.sheldon.getName() + " modified")), new Matcher[0]);
        }
        finally {
            this.deleteEmployee(this.sheldon.getId());
        }
    }

    @Test
    public void loadBalancingPolicy() {
        try {
            this.insertEmployee(this.sheldon, "direct:createCustomLoadBalancingPolicy");
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/cassandraql/checkLoadBalancingPolicy", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"true"), new Matcher[0]);
        }
        finally {
            this.deleteEmployee(this.sheldon.getId());
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void cqlStatementViaHeader(boolean queryAsSimpleStatement) {
        try {
            this.insertEmployee(this.sheldon, "direct:create");
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{this.sheldon.getId()}).queryParam("cql", new Object[]{"SELECT * FROM employee WHERE id = ?"}).queryParam("queryAsSimpleStatement", new Object[]{queryAsSimpleStatement}).get("/cassandraql/cqlHeaderQuery", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"[id:1, address:'Alpha Centauri', name:'Sheldon']"), new Matcher[0]);
        }
        finally {
            this.deleteEmployee(this.sheldon.getId());
        }
    }

    private void assertEmployee(int id, Matcher<?> matcher) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{id}).get("/cassandraql/getEmployee", new Object[0])).then()).statusCode(200)).body(matcher, new Matcher[0]);
    }

    private void assertAllEmployees(Matcher<?> matcher) {
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/cassandraql/getAllEmployees", (Object[])new Object[0]).then()).statusCode(200)).body(matcher, new Matcher[0]);
    }

    private void insertEmployee(Employee employee, String endpointUri) {
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{employee.getId()}).queryParam("name", new Object[]{employee.getName()}).queryParam("address", new Object[]{employee.getAddress()}).queryParam("endpointUri", new Object[]{endpointUri}).post("/cassandraql/insertEmployee", new Object[0])).then()).statusCode(204);
    }

    private void updateEmployee(Employee employee) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{employee.getId()}).queryParam("name", new Object[]{employee.getName()}).queryParam("address", new Object[]{employee.getAddress()}).patch("/cassandraql/updateEmployee", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)String.valueOf(true)), new Matcher[0]);
    }

    private void deleteEmployee(int id) {
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("id", new Object[]{id}).delete("/cassandraql/deleteEmployeeById", new Object[0])).then()).statusCode(204);
    }
}

