/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.cassandraql.it;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Map;
import org.apache.camel.util.CollectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.CassandraContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;

public class CassandraqlTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraqlTestResource.class);
    private static final int PORT = 9042;
    private static final String DOCKER_IMAGE_NAME = "cassandra:4.0.1";
    protected CassandraContainer<?> container;

    public Map<String, String> start() {
        LOGGER.info(TestcontainersConfiguration.getInstance().toString());
        try {
            this.container = ((CassandraContainer)((CassandraContainer)new CassandraContainer(DOCKER_IMAGE_NAME).withExposedPorts(new Integer[]{9042})).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Created default superuser role.*", (int)1))).withConfigurationOverride("/cassandra");
            this.container.start();
            this.initDB(this.container);
            String cassandraUrl = this.container.getHost() + ":" + this.container.getMappedPort(9042);
            return CollectionHelper.mapOf((Object)"quarkus.cassandra.contact-points", (Object)cassandraUrl, (Object[])new Object[]{"quarkus.cassandra.local-datacenter", "datacenter1", "quarkus.cassandra.auth.username", this.container.getUsername(), "quarkus.cassandra.auth.password", this.container.getPassword(), "quarkus.cassandra.keyspace", "test"});
        }
        catch (Exception e) {
            LOGGER.error("Container does not start", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void initDB(CassandraContainer<?> container) {
        Cluster cluster = Cluster.builder().addContactPoint(container.getHost()).withPort(container.getMappedPort(CassandraContainer.CQL_PORT.intValue()).intValue()).withCredentials(container.getUsername(), container.getPassword()).withoutJMXReporting().build();
        try (Session session = cluster.connect();){
            session.execute("CREATE KEYSPACE IF NOT EXISTS test WITH replication = \n{'class':'SimpleStrategy','replication_factor':'1'};");
            session.execute("CREATE TABLE test.employee(\n   id int PRIMARY KEY,\n   name text,\n   address text\n   );");
            session.execute("CREATE TABLE test.CAMEL_IDEMPOTENT (\n  NAME varchar,\n  KEY varchar,\n  PRIMARY KEY (NAME, KEY)\n);");
            session.execute("CREATE TABLE test.CAMEL_AGGREGATION (\n  NAME varchar,\n  KEY varchar,\n  EXCHANGE_ID varchar,\n  EXCHANGE blob,\n  PRIMARY KEY (NAME, KEY)\n);");
        }
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

