/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.cassandraql.it;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import java.util.Map;
import org.apache.camel.quarkus.component.cassandraql.it.CassandraqlResource;
import org.apache.camel.quarkus.testcontainers.ContainerResourceLifecycleManager;
import org.apache.camel.util.CollectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.CassandraContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.TestcontainersConfiguration;

public class CassandraqlTestResource
implements ContainerResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraqlTestResource.class);
    private static final int PORT = 9042;
    private static final String DOCKER_IMAGE_NAME = "cassandra:3.11.2";
    protected GenericContainer container;

    public Map<String, String> start() {
        LOGGER.info(TestcontainersConfiguration.getInstance().toString());
        try {
            this.container = new CassandraContainer(DOCKER_IMAGE_NAME).withExposedPorts(new Integer[]{9042});
            this.container.start();
            this.initDB((CassandraContainer)this.container);
            return CollectionHelper.mapOf((Object)CassandraqlResource.DB_URL_PARAMETER, (Object)(this.container.getContainerIpAddress() + ":" + this.container.getMappedPort(9042)), (Object[])new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("Container does not start", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void initDB(CassandraContainer cc) {
        Cluster cluster = cc.getCluster();
        try (Session session = cluster.connect();){
            session.execute("CREATE KEYSPACE IF NOT EXISTS test WITH replication = \n{'class':'SimpleStrategy','replication_factor':'1'};");
            session.execute("CREATE TABLE test.employee(\n   id int PRIMARY KEY,\n   name text,\n   address text\n   );");
        }
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

