/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.caffeine.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Locale;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@QuarkusTest
class CaffeineTest {
    CaffeineTest() {
    }

    @Test
    public void loadComponentCaffeineCache() {
        ((ValidatableResponse)RestAssured.get((String)"/caffeine/component/{componentName}", (Object[])new Object[]{"caffeine-cache"}).then()).statusCode(200);
        ((ValidatableResponse)RestAssured.get((String)"/caffeine/component/{componentName}", (Object[])new Object[]{"caffeine-loadcache"}).then()).statusCode(200);
    }

    @ParameterizedTest
    @ValueSource(strings={"embedded", "shared-cache"})
    public void putAndGet(String cacheName) {
        String key = "the-key";
        String value = UUID.randomUUID().toString();
        ((ValidatableResponse)((Response)RestAssured.given().body(value).post("/caffeine/request/caffeine-cache/{cacheName}/{key}", new Object[]{cacheName, "the-key"})).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/caffeine/request/caffeine-cache/{cacheName}/{key}", (Object[])new Object[]{cacheName, "the-key"}).then()).statusCode(200)).body(Matchers.is((Object)value), new Matcher[0]);
    }

    @Test
    public void valueIsLoadedByTheCache() {
        String key = "the-key";
        String value = "the-key";
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/caffeine/request/caffeine-loadcache/{cacheName}/{key}", (Object[])new Object[]{"loading-cache", "the-key"}).then()).statusCode(200)).body(Matchers.is((Object)"the-key".toUpperCase(Locale.US)), new Matcher[0]);
    }
}

