/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.caffeine.it;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.apache.camel.FluentProducerTemplate;

@Path(value="/caffeine")
@ApplicationScoped
public class CaffeineResource {
    @Inject
    CamelContext context;
    @Inject
    FluentProducerTemplate template;

    @Path(value="/component/{componentName}")
    @GET
    @Produces(value={"text/plain"})
    public Response loadComponent(@PathParam(value="componentName") String componentName) {
        return this.context.getComponent(componentName) != null ? Response.ok().build() : Response.status((int)500, (String)(componentName + " could not be loaded from the Camel context")).build();
    }

    @Path(value="/request/{componentName}/{cacheName}/{key}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String request(@PathParam(value="componentName") String componentName, @PathParam(value="cacheName") String cacheName, @PathParam(value="key") String key, String value) {
        FluentProducerTemplate t = this.template.toF("%s://%s", new Object[]{componentName, cacheName});
        t.withHeader("CamelCaffeineAction", (Object)"PUT");
        t.withHeader("CamelCaffeineKey", (Object)key);
        t.withBody((Object)value);
        return (String)t.request(String.class);
    }

    @Path(value="/request/{componentName}/{cacheName}/{key}")
    @GET
    @Produces(value={"text/plain"})
    public String request(@PathParam(value="componentName") String componentName, @PathParam(value="cacheName") String cacheName, @PathParam(value="key") String key) {
        FluentProducerTemplate t = this.template.toF("%s://%s", new Object[]{componentName, cacheName});
        t.withHeader("CamelCaffeineAction", (Object)"GET");
        t.withHeader("CamelCaffeineKey", (Object)key);
        return (String)t.request(String.class);
    }
}

