/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.caffeine.it;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Locale;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;

@ApplicationScoped
public class CaffeineCaches {
    public static final String SHARED_CACHE_NAME = "shared-cache";
    public static final String LOADING_CACHE_NAME = "loading-cache";

    @Named(value="shared-cache")
    static Cache<String, String> shared() {
        return Caffeine.newBuilder().build();
    }

    @Named(value="loading-cache")
    static LoadingCache<String, String> loading() {
        return Caffeine.newBuilder().build((CacheLoader)new ToUpper());
    }

    public static class ToUpper
    implements CacheLoader<String, String> {
        public String load(String key) throws Exception {
            return key.toUpperCase(Locale.US);
        }
    }
}

