/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.browse.it;

import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.spi.BrowsableEndpoint;

@Path(value="/browse")
public class BrowseResource {
    public static final String MESSAGE = "Hello World";
    @Inject
    CamelContext context;
    @Inject
    ProducerTemplate template;

    @GET
    @Produces(value={"text/plain"})
    public Response getBrowsedExchanges() throws Exception {
        this.template.sendBody("direct:browse", (Object)MESSAGE);
        BrowsableEndpoint browse = (BrowsableEndpoint)this.context.getEndpoint("browse:messageReceived", BrowsableEndpoint.class);
        List exchanges = browse.getExchanges();
        if (exchanges.size() == 1) {
            String result = (String)((Exchange)exchanges.get(0)).getMessage().getBody(String.class);
            return Response.ok((Object)result).build();
        }
        throw new IllegalStateException("Expected 1 browsed exchange but got " + exchanges.size());
    }
}

