/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.box.it;

import com.box.sdk.BoxFile;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;

@Path(value="/box")
@ApplicationScoped
public class BoxResource {
    private static final Logger LOG = Logger.getLogger(BoxResource.class);
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/uploadFile/{parentFolder}/{name}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response uploadFile(String content, @PathParam(value="parentFolder") String parentFolder, @PathParam(value="name") String name) throws Exception {
        LOG.infof("Uploading file to box: %s under the root folder with name %s", (Object)content, (Object)name);
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("CamelBox.parentFolderId", parentFolder);
        headers.put("CamelBox.content", new ByteArrayInputStream(content.getBytes()));
        headers.put("CamelBox.fileName", name);
        BoxFile response = (BoxFile)this.producerTemplate.requestBodyAndHeaders("direct:upload-file", null, headers, BoxFile.class);
        LOG.infof("Got response from box: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response.getID()).build();
    }

    @Path(value="/downloadFile")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response downloadFile(String fileId) throws Exception {
        LOG.infof("Downloading from box: %s", (Object)fileId);
        HashMap<String, ByteArrayOutputStream> headers = new HashMap<String, ByteArrayOutputStream>();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        headers.put("CamelBox.output", output);
        this.producerTemplate.requestBodyAndHeaders("direct:download-file", (Object)fileId, headers, OutputStream.class);
        String response = output.toString();
        LOG.infof("Got response from box: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/deleteFile")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response deleteFile(String fileId) throws Exception {
        LOG.infof("Deleting file from Box with id: %s", (Object)fileId);
        String response = (String)this.producerTemplate.requestBody("direct:delete-file", (Object)fileId, String.class);
        LOG.infof("Got response from box: %s", (Object)response);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }
}

