/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.bindy.it;

import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.dataformat.bindy.kvp.BindyKeyValuePairDataFormat;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.BindyDataFormat;
import org.apache.camel.model.dataformat.BindyType;
import org.apache.camel.quarkus.component.bindy.it.model.CsvOrder;
import org.apache.camel.quarkus.component.bindy.it.model.FixedLengthOrder;
import org.apache.camel.quarkus.component.bindy.it.model.FixedLengthWithLocale;
import org.apache.camel.quarkus.component.bindy.it.model.MessageOrder;
import org.apache.camel.spi.DataFormat;

public class BindyTestRoute
extends RouteBuilder {
    public void configure() {
        this.from("direct:marshal-csv-record").marshal().bindy(BindyType.Csv, CsvOrder.class);
        this.from("direct:unmarshal-csv-record").unmarshal().bindy(BindyType.Csv, CsvOrder.class);
        BindyDataFormat bindyFixedLengthDataFormat = new BindyDataFormat();
        bindyFixedLengthDataFormat.setClassType(FixedLengthOrder.class);
        bindyFixedLengthDataFormat.setType(BindyType.Fixed.name());
        this.from("direct:marshal-fixed-length-record").marshal((DataFormatDefinition)bindyFixedLengthDataFormat);
        this.from("direct:unmarshal-fixed-length-record").unmarshal((DataFormatDefinition)bindyFixedLengthDataFormat);
        BindyDataFormat bindyFixedLengthWithLocaleDataFormat = new BindyDataFormat();
        bindyFixedLengthWithLocaleDataFormat.setClassType(FixedLengthWithLocale.class);
        bindyFixedLengthWithLocaleDataFormat.setType(BindyType.Fixed.name());
        bindyFixedLengthWithLocaleDataFormat.setLocale("fr");
        this.from("direct:marshal-fixed-length-with-locale").marshal((DataFormatDefinition)bindyFixedLengthWithLocaleDataFormat);
        BindyKeyValuePairDataFormat bindyMessageDataFormat = new BindyKeyValuePairDataFormat(MessageOrder.class);
        this.from("direct:marshal-message").marshal((DataFormat)bindyMessageDataFormat);
        this.from("direct:unmarshal-message").unmarshal((DataFormat)bindyMessageDataFormat);
    }
}

