/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.bindy.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.bindy.it.model.CsvOrder;
import org.apache.camel.quarkus.component.bindy.it.model.FixedLengthOrder;
import org.apache.camel.quarkus.component.bindy.it.model.FixedLengthWithLocale;
import org.apache.camel.quarkus.component.bindy.it.model.Header;
import org.apache.camel.quarkus.component.bindy.it.model.MessageOrder;
import org.apache.camel.quarkus.component.bindy.it.model.NameWithLengthSuffix;
import org.apache.camel.quarkus.component.bindy.it.model.Security;
import org.apache.camel.quarkus.component.bindy.it.model.Trailer;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;

@Path(value="/bindy")
@ApplicationScoped
public class BindyResource {
    private static final Logger LOG = Logger.getLogger(BindyResource.class);
    private static final String CSV = "bindy-order-name-16,BINDY-COUNTRY,fr,A1B2C3";
    private static final String FIXED_LENGTH_ORDER = "BobSpa\r\n";
    private static final String MESSAGE_ORDER = "1=BE.CHM.001\u00018=BEGIN\u00019=20\u000110=220\u000122=4\u000158=camel - quarkus - bindy test\u0001\r\n";
    @Inject
    ProducerTemplate template;

    @Path(value="/marshalCsvRecordShouldSucceed")
    @GET
    public void marshalCsvRecordShouldSucceed() {
        LOG.debugf("Invoking marshalCsvRecordShouldSucceed()", new Object[0]);
        CsvOrder order = new CsvOrder();
        order.setNameWithLengthSuffix(NameWithLengthSuffix.ofString("bindy-order-name"));
        order.setCountry("bindy-country");
        order.setLanguage("fr");
        order.setClientReference("A1B2C3");
        String marshalled = (String)this.template.requestBody("direct:marshal-csv-record", (Object)order, String.class);
        Assertions.assertEquals((Object)CSV, (Object)marshalled);
    }

    @Path(value="/unMarshalCsvRecordShouldSucceed")
    @GET
    public void unMarshalCsvRecordShouldSucceed() {
        LOG.debugf("Invoking unMarshalCsvRecordShouldSucceed()", new Object[0]);
        CsvOrder order = (CsvOrder)this.template.requestBody("direct:unmarshal-csv-record", (Object)CSV, CsvOrder.class);
        Assertions.assertNotNull((Object)order);
        Assertions.assertNotNull((Object)order.getNameWithLengthSuffix());
        Assertions.assertEquals((Object)"bindy-order-name-16-19", (Object)order.getNameWithLengthSuffix().toString());
        Assertions.assertEquals((Object)"B_ND_-C__NTR_", (Object)order.getCountry());
        Assertions.assertEquals((Object)"FR", (Object)order.getLanguage());
        Assertions.assertEquals((Object)"A_B_C_", (Object)order.getClientReference());
    }

    @Path(value="/marshalFixedLengthRecordShouldSucceed")
    @GET
    public void marshalFixedLengthRecordShouldSucceed() {
        LOG.debugf("Invoking marshalFixedLengthRecordShouldSucceed()", new Object[0]);
        FixedLengthOrder order = new FixedLengthOrder();
        order.setName("Bob");
        order.setCountry("Spa");
        String marshalled = (String)this.template.requestBody("direct:marshal-fixed-length-record", (Object)order, String.class);
        Assertions.assertEquals((Object)FIXED_LENGTH_ORDER, (Object)marshalled);
    }

    @Path(value="/unMarshalFixedLengthRecordShouldSucceed")
    @GET
    public void unMarshalFixedLengthRecordShouldSucceed() {
        LOG.debugf("Invoking unMarshalFixedLengthRecordShouldSucceed()", new Object[0]);
        String uri = "direct:unmarshal-fixed-length-record";
        FixedLengthOrder order = (FixedLengthOrder)this.template.requestBody(uri, (Object)FIXED_LENGTH_ORDER, FixedLengthOrder.class);
        Assertions.assertNotNull((Object)order);
        Assertions.assertEquals((Object)"Bob", (Object)order.getName());
        Assertions.assertEquals((Object)"Spa", (Object)order.getCountry());
    }

    @Path(value="/marshalFixedLengthWithLocaleShouldSucceed")
    @GET
    public void marshalFixedLengthWithLocaleShouldSucceed() {
        LOG.debugf("Invoking marshalFixedLengthWithLocaleShouldSucceed()", new Object[0]);
        FixedLengthWithLocale object = new FixedLengthWithLocale();
        object.setNumber(3.2);
        String marshalled = (String)this.template.requestBody("direct:marshal-fixed-length-with-locale", (Object)object, String.class);
        Assertions.assertEquals((Object)"3,200\r\n", (Object)marshalled);
    }

    @Path(value="/marshalMessageShouldSucceed")
    @GET
    public void marshalMessageShouldSucceed() {
        LOG.debugf("Invoking marshalMessageShouldSucceed()", new Object[0]);
        MessageOrder order = new MessageOrder();
        order.setAccount("BE.CHM.001");
        order.setHeader(new Header());
        order.getHeader().setBeginString("BEGIN");
        order.getHeader().setBodyLength(20);
        order.setSecurities(new ArrayList<Security>());
        order.getSecurities().add(new Security());
        order.getSecurities().get(0).setIdSource("4");
        order.setText("camel - quarkus - bindy test");
        order.setTrailer(new Trailer());
        order.getTrailer().setCheckSum(220);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(MessageOrder.class.getName(), order);
        model.put(Header.class.getName(), order.getHeader());
        model.put(Trailer.class.getName(), order.getTrailer());
        model.put(Security.class.getName(), order.getSecurities().get(0));
        String marshalled = (String)this.template.requestBody("direct:marshal-message", Arrays.asList(model), String.class);
        Assertions.assertEquals((Object)MESSAGE_ORDER, (Object)marshalled);
    }

    @Path(value="/unMarshalMessageShouldSucceed")
    @GET
    public void unMarshalMessageShouldSucceed() {
        LOG.debugf("Invoking unMarshalMessageShouldSucceed()", new Object[0]);
        MessageOrder order = (MessageOrder)this.template.requestBody("direct:unmarshal-message", (Object)MESSAGE_ORDER, MessageOrder.class);
        Assertions.assertNotNull((Object)order);
        Assertions.assertEquals((Object)"BE.CHM.001", (Object)order.getAccount());
        Assertions.assertNotNull((Object)order.getHeader());
        Assertions.assertEquals((Object)"BEGIN", (Object)order.getHeader().getBeginString());
        Assertions.assertEquals((int)20, (int)order.getHeader().getBodyLength());
        Assertions.assertNotNull(order.getSecurities());
        Assertions.assertEquals((int)1, (int)order.getSecurities().size());
        Assertions.assertEquals((Object)"4", (Object)order.getSecurities().get(0).getIdSource());
        Assertions.assertEquals((Object)"camel - quarkus - bindy test", (Object)order.getText());
        Assertions.assertNotNull((Object)order.getTrailer());
        Assertions.assertEquals((int)220, (int)order.getTrailer().getCheckSum());
    }
}

