/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.bindy.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.ArrayList;
import org.apache.camel.quarkus.component.bindy.it.model.Header;
import org.apache.camel.quarkus.component.bindy.it.model.MessageOrder;
import org.apache.camel.quarkus.component.bindy.it.model.Security;
import org.apache.camel.quarkus.component.bindy.it.model.Trailer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class MessageRecordTest {
    private static final String MESSAGE_ORDER = "1=BE.CHM.001\u00018=BEGIN\u00019=20\u000110=220\u000122=4\u000158=camel - quarkus - bindy test\u0001\r\n";

    MessageRecordTest() {
    }

    @Test
    public void jsonToMessageShouldSucceed() {
        MessageOrder order = new MessageOrder();
        order.setAccount("BE.CHM.001");
        order.setHeader(new Header());
        order.getHeader().setBeginString("BEGIN");
        order.getHeader().setBodyLength(20);
        order.setSecurities(new ArrayList());
        order.getSecurities().add(new Security());
        ((Security)order.getSecurities().get(0)).setIdSource("4");
        order.setText("camel - quarkus - bindy test");
        order.setTrailer(new Trailer());
        order.getTrailer().setCheckSum(220);
        String messageOrder = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)order).get("/bindy/jsonToMessage", new Object[0])).then()).statusCode(200)).extract().asString();
        Assertions.assertEquals((Object)MESSAGE_ORDER, (Object)messageOrder);
    }

    @Test
    public void messageToJsonShouldSucceed() {
        MessageOrder order = (MessageOrder)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(MESSAGE_ORDER).get("/bindy/messageToJson", new Object[0])).then()).statusCode(200)).extract().as(MessageOrder.class);
        Assertions.assertNotNull((Object)order);
        Assertions.assertEquals((Object)"BE.CHM.001", (Object)order.getAccount());
        Assertions.assertNotNull((Object)order.getHeader());
        Assertions.assertEquals((Object)"BEGIN", (Object)order.getHeader().getBeginString());
        Assertions.assertEquals((int)20, (int)order.getHeader().getBodyLength());
        Assertions.assertNotNull((Object)order.getSecurities());
        Assertions.assertEquals((int)1, (int)order.getSecurities().size());
        Assertions.assertEquals((Object)"4", (Object)((Security)order.getSecurities().get(0)).getIdSource());
        Assertions.assertEquals((Object)"camel - quarkus - bindy test", (Object)order.getText());
        Assertions.assertNotNull((Object)order.getTrailer());
        Assertions.assertEquals((int)220, (int)order.getTrailer().getCheckSum());
    }
}

