/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.bindy.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.bindy.it.model.FixedLengthOrder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class FixedLengthRecordTest {
    private static final String FIXED_LENGTH_ORDER = "BobSpa\r\n";

    FixedLengthRecordTest() {
    }

    @Test
    public void jsonToFixedLengthShouldSucceed() {
        FixedLengthOrder order = new FixedLengthOrder();
        order.setName("Bob");
        order.setCountry("Spa");
        String fixedLengthOrder = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)order).get("/bindy/jsonToFixedLength", new Object[0])).then()).statusCode(200)).extract().asString();
        Assertions.assertEquals((Object)FIXED_LENGTH_ORDER, (Object)fixedLengthOrder);
    }

    @Test
    public void fixedLengthToJsonShouldSucceed() {
        FixedLengthOrder order = (FixedLengthOrder)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(FIXED_LENGTH_ORDER).get("/bindy/fixedLengthToJson", new Object[0])).then()).statusCode(200)).extract().as(FixedLengthOrder.class);
        Assertions.assertNotNull((Object)order);
        Assertions.assertEquals((Object)"Bob", (Object)order.getName());
        Assertions.assertEquals((Object)"Spa", (Object)order.getCountry());
    }
}

