/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.bindy.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.bindy.it.model.CsvOrder;
import org.apache.camel.quarkus.component.bindy.it.model.NameWithLengthSuffix;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
class CsvRecordTest {
    private static final String CSV = "bindy-order-name-16,BINDY-COUNTRY";

    CsvRecordTest() {
    }

    @Test
    public void jsonToCsvShouldSucceed() {
        CsvOrder order = new CsvOrder();
        order.setNameWithLengthSuffix(NameWithLengthSuffix.ofString((String)"bindy-order-name"));
        order.setCountry("bindy-country");
        String csvOrder = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)order).get("/bindy/jsonToCsv", new Object[0])).then()).statusCode(200)).extract().asString();
        Assertions.assertEquals((Object)CSV, (Object)csvOrder);
    }

    @Test
    public void csvToJsonShouldSucceed() {
        CsvOrder order = (CsvOrder)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(CSV).get("/bindy/csvToJson", new Object[0])).then()).statusCode(200)).extract().as(CsvOrder.class);
        Assertions.assertNotNull((Object)order);
        Assertions.assertNotNull((Object)order.getNameWithLengthSuffix());
        Assertions.assertEquals((Object)"bindy-order-name-16-19", (Object)order.getNameWithLengthSuffix().toString());
        Assertions.assertEquals((Object)"B_ND_-C__NTR_", (Object)order.getCountry());
    }
}

