/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.bindy.it.model;

import java.util.List;
import org.apache.camel.dataformat.bindy.annotation.KeyValuePairField;
import org.apache.camel.dataformat.bindy.annotation.Link;
import org.apache.camel.dataformat.bindy.annotation.Message;
import org.apache.camel.dataformat.bindy.annotation.OneToMany;
import org.apache.camel.quarkus.component.bindy.it.model.Header;
import org.apache.camel.quarkus.component.bindy.it.model.Security;
import org.apache.camel.quarkus.component.bindy.it.model.Trailer;

@Message(keyValuePairSeparator="=", pairSeparator="\\u0001")
public class MessageOrder {
    @Link
    Header header;
    @Link
    Trailer trailer;
    @KeyValuePairField(tag=1)
    private String account;
    @KeyValuePairField(tag=58)
    private String text;
    @OneToMany(mappedTo="org.apache.camel.quarkus.component.bindy.it.model.Security")
    private List<Security> securities;

    public List<Security> getSecurities() {
        return this.securities;
    }

    public void setSecurities(List<Security> securities) {
        this.securities = securities;
    }

    public Header getHeader() {
        return this.header;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public Trailer getTrailer() {
        return this.trailer;
    }

    public void setTrailer(Trailer trailer) {
        this.trailer = trailer;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageOrder.class.getName() + " --> 1: " + this.account + ", 58: " + this.text + System.lineSeparator());
        if (this.header != null) {
            sb.append("  " + this.header.toString() + System.lineSeparator());
        }
        if (this.securities != null) {
            for (Security sec : this.securities) {
                sb.append("  " + sec.toString() + System.lineSeparator());
            }
        }
        if (this.trailer != null) {
            sb.append("  " + this.trailer.toString() + System.lineSeparator());
        }
        return sb.toString();
    }
}

