/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.bindy.it;

import java.util.Arrays;
import java.util.HashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.bindy.it.model.CsvOrder;
import org.apache.camel.quarkus.component.bindy.it.model.FixedLengthOrder;
import org.apache.camel.quarkus.component.bindy.it.model.Header;
import org.apache.camel.quarkus.component.bindy.it.model.MessageOrder;
import org.apache.camel.quarkus.component.bindy.it.model.Security;
import org.apache.camel.quarkus.component.bindy.it.model.Trailer;
import org.jboss.logging.Logger;

@Path(value="/bindy")
@ApplicationScoped
public class BindyResource {
    private static final Logger LOG = Logger.getLogger(BindyResource.class);
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/jsonToCsv")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String jsonToCsv(CsvOrder order) {
        LOG.infof("Invoking  jsonToCsv: %s", (Object)order);
        return (String)this.producerTemplate.requestBody("direct:jsonToCsv", (Object)order, String.class);
    }

    @Path(value="/csvToJson")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public CsvOrder csvToJson(String csvOrder) {
        LOG.infof("Invoking  csvToJson: %s", (Object)csvOrder);
        return (CsvOrder)this.producerTemplate.requestBody("direct:csvToJson", (Object)csvOrder, CsvOrder.class);
    }

    @Path(value="/jsonToFixedLength")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String jsonToFixedLength(FixedLengthOrder order) {
        LOG.infof("Invoking  jsonToFixedLength: %s", (Object)order);
        return (String)this.producerTemplate.requestBody("direct:jsonToFixedLength", (Object)order, String.class);
    }

    @Path(value="/fixedLengthToJson")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public FixedLengthOrder fixedLengthToJson(String fixedLengthOrder) {
        LOG.infof("Invoking  fixedLengthToJson: %s", (Object)fixedLengthOrder);
        return (FixedLengthOrder)this.producerTemplate.requestBody("direct:fixedLengthToJson", (Object)fixedLengthOrder, FixedLengthOrder.class);
    }

    @Path(value="/jsonToMessage")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String jsonToMessage(MessageOrder order) {
        LOG.infof("Invoking  jsonToMessage: %s", (Object)order);
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put(MessageOrder.class.getName(), order);
        model.put(Header.class.getName(), order.getHeader());
        model.put(Trailer.class.getName(), order.getTrailer());
        model.put(Security.class.getName(), order.getSecurities().get(0));
        return (String)this.producerTemplate.requestBody("direct:jsonToMessage", Arrays.asList(model), String.class);
    }

    @Path(value="/messageToJson")
    @GET
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    public MessageOrder messageToJson(String messageOrder) {
        LOG.infof("Invoking  messageToJson: %s", (Object)messageOrder);
        return (MessageOrder)this.producerTemplate.requestBody("direct:messageToJson", (Object)messageOrder, MessageOrder.class);
    }
}

