/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.bean;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.camel.quarkus.component.bean.model.Employee;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class BeanMethodTest {
    private static final List<Employee> EMPLOYEES = Arrays.asList(new Employee("Michael", "Singer", "junior"), new Employee("Joe", "Doe", "junior"), new Employee("Susanne", "First", "senior"), new Employee("Max", "Mustermann", "senior"));

    static void assertFilterAndExpression(String route, String ... expectedNames) {
        for (Employee employee : EMPLOYEES) {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)employee).post("/bean-method/employee/" + route, new Object[0])).then()).statusCode(201);
        }
        Awaitility.await().pollInterval(50L, TimeUnit.MILLISECONDS).atMost(30L, TimeUnit.SECONDS).until(() -> (String[])((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/bean-method/collectedNames/" + route, new Object[0])).then()).statusCode(200)).extract().body().as(String[].class), names -> Arrays.equals(names, expectedNames));
    }

    @Test
    public void beanFromRegistryByName() {
        BeanMethodTest.assertFilterAndExpression("beanFromRegistryByName", "Susanne", "Max");
    }

    @Test
    public void beanByClassName() {
        BeanMethodTest.assertFilterAndExpression("beanByClassName", "Singer", "Doe");
    }

    @Test
    public void beanInstance() {
        BeanMethodTest.assertFilterAndExpression("beanInstance", "Singer", "Doe");
    }
}

