/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.bean.method;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.bean.model.Employee;

@Path(value="/bean-method")
public class BeanMethodResource {
    @Inject
    ProducerTemplate template;
    @Inject
    @Named(value="collected-names")
    Map<String, List<String>> collectedNames;

    @Path(value="/employee/{route}")
    @POST
    @Consumes(value={"application/json"})
    public Response employee(Employee employee, @PathParam(value="route") String route) {
        this.template.sendBody("direct:" + route, (Object)employee);
        return Response.created((URI)URI.create("https://camel.apache.org")).build();
    }

    @Path(value="/collectedNames/{key}")
    @GET
    @Produces(value={"application/json"})
    public List<String> collectedNames(@PathParam(value="key") String key) {
        return this.collectedNames.get(key);
    }
}

