/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.bean.eip;

import io.quarkus.runtime.annotations.RegisterForReflection;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Consume;
import org.apache.camel.DynamicRouter;
import org.apache.camel.builder.RouteBuilder;

@ApplicationScoped
public class EipRoutes
extends RouteBuilder {
    public void configure() {
        this.from("direct:dynamicRouter").dynamicRouter().method("myDynamicRouter", "route");
    }

    @Produces
    @Singleton
    @Named(value="dynamicRouterResult0")
    List<String> dynamicRouterResult0() {
        return new ArrayList<String>();
    }

    @Produces
    @Singleton
    @Named(value="dynamicRouterResult1")
    List<String> dynamicRouterResult1() {
        return new ArrayList<String>();
    }

    @Produces
    @Singleton
    @Named(value="dynamicRouterAnnotationResult0")
    List<String> dynamicRouterResult2() {
        return new ArrayList<String>();
    }

    @Produces
    @Singleton
    @Named(value="dynamicRouterAnnotationResult1")
    List<String> dynamicRouterResult3() {
        return new ArrayList<String>();
    }

    @RegisterForReflection(targets={ArrayList.class})
    static class DynamicRouterWithAnnotation {
        DynamicRouterWithAnnotation() {
        }

        @Consume(value="direct:dynamicRouterAnnotation")
        @DynamicRouter
        public String route(String body) {
            try {
                int val = Integer.parseInt(body);
                return "bean:dynamicRouterAnnotationResult" + val % 2 + "?method=add";
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    @Singleton
    @Named(value="myDynamicRouter")
    @RegisterForReflection
    static class CustomDynamicRouter {
        CustomDynamicRouter() {
        }

        public String route(String body) {
            try {
                int val = Integer.parseInt(body);
                return "bean:dynamicRouterResult" + val % 2 + "?method=add";
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }
}

