/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.bean;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.quarkus.component.bean.Counter;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class EagerAppScopedRouteBuilder
extends RouteBuilder {
    static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger(0);
    static final AtomicInteger CONFIGURE_COUNTER = new AtomicInteger(0);
    @Inject
    Counter counter;
    @ConfigProperty(name="my.foo.property", defaultValue="not found")
    String myFooValue;

    @PostConstruct
    public void postConstruct() {
        INSTANCE_COUNTER.incrementAndGet();
    }

    public void addRoutesToCamelContext(CamelContext context) throws Exception {
        CONFIGURE_COUNTER.incrementAndGet();
        super.addRoutesToCamelContext(context);
    }

    public void configure() {
        ((RouteDefinition)this.from("direct:increment").id("counter")).setBody(exchange -> this.counter.increment());
        ((RouteDefinition)this.from("direct:config-property").id("config-property")).setBody(exchange -> "myFooValue = " + this.myFooValue);
    }

    public Counter getCounter() {
        return this.counter;
    }
}

