/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.bean;

import io.quarkus.runtime.annotations.RegisterForReflection;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.BindToRegistry;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.quarkus.component.bean.WithHandlerBean;
import org.apache.camel.support.DefaultExchange;

@ApplicationScoped
public class BeanRoutes
extends RouteBuilder {
    static final AtomicInteger CONFIGURE_COUNTER = new AtomicInteger(0);
    @Inject
    @Named(value="collected-names")
    Map<String, List<String>> collectedNames;

    public void addRoutesToCamelContext(CamelContext context) throws Exception {
        CONFIGURE_COUNTER.incrementAndGet();
        super.addRoutesToCamelContext(context);
    }

    public void configure() {
        ((ExpressionNode)((RouteDefinition)this.from("direct:process-order").setHeader(MyOrderService.class.getName(), () -> new MyOrderService())).split((Expression)this.body().tokenize("@"), this::aggregate).process(this.stateless(MyOrderService.class.getName(), "handleOrder"))).end().process(this.stateless(MyOrderService.class.getName(), "buildCombinedResponse"));
        this.from("direct:named").to("bean:namedBean?method=hello");
        this.from("direct:identified").to("bean:identifiedBean?method=hello");
        this.from("direct:method").bean(MyBean.class, "sayHello");
        this.from("direct:handler").to("bean:withHandler");
        this.from("direct:handlerOnProxy").to("bean:withHandlerOnProxy");
        this.from("direct:with-language-param-bindings").routeId("wlpb-route-31wp").to("bean:withLanguageParamBindingsBean");
        this.from("direct:methodWithExchangeArg").to("bean:namedBean");
        this.from("direct:completionStageBean").to("bean:completionStageBean?method=hello");
        this.from("direct:multiArgMethod").to("bean:parametersBean?method=multiArgMethod");
        this.from("direct:parameterBindingAnnotations").to("bean:parametersBean?method=parameterBindingAnnotations");
        this.from("direct:parameterLiterals").to("bean:parametersBean?method=parameterLiterals(*, true)");
        this.from("direct:parameterTypes").to("bean:parametersBean?method=parameterTypes(String.class)");
        this.from("direct:produceInterface").process(e -> e.getMessage().setBody((Object)("produceInterface " + (String)e.getMessage().getBody(String.class))));
    }

    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        List<String> orders;
        if (oldExchange != null) {
            orders = (List)oldExchange.getIn().getBody(List.class);
        } else {
            orders = new ArrayList();
            oldExchange = new DefaultExchange(newExchange.getContext());
            oldExchange.getIn().copyFromWithNewBody(newExchange.getIn(), orders);
        }
        String newLine = (String)newExchange.getIn().getBody(String.class);
        this.log.debug("Aggregate old orders: " + orders);
        this.log.debug("Aggregate new order: " + newLine);
        orders.add(newLine);
        return oldExchange;
    }

    private Processor stateless(final String header, final String method) {
        return new AsyncProcessor(){

            public boolean process(Exchange exchange, AsyncCallback callback) {
                return this.getBeanProcess(exchange).process(exchange, callback);
            }

            public CompletableFuture<Exchange> processAsync(Exchange exchange) {
                return this.getBeanProcess(exchange).processAsync(exchange);
            }

            public void process(Exchange exchange) throws Exception {
                this.getBeanProcess(exchange).process(exchange);
            }

            protected BeanProcessor getBeanProcess(Exchange exchange) {
                BeanProcessor bp = new BeanProcessor(exchange.getIn().getHeader(header), exchange.getContext());
                bp.setMethod(method);
                return bp;
            }
        };
    }

    @BindToRegistry
    public static WithHandlerBean withHandler() {
        return new WithHandlerBean();
    }

    @RegisterForReflection
    public class MyOrderService {
        private int counter;

        public String handleOrder(String line) {
            BeanRoutes.this.log.debug("HandleOrder: " + line);
            return "(id=" + ++this.counter + ",item=" + line + ")";
        }

        public Map<String, Object> buildCombinedResponse(List<String> lines) {
            BeanRoutes.this.log.debug("BuildCombinedResponse: " + lines);
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put("success", true);
            result.put("lines", lines);
            return result;
        }
    }

    @RegisterForReflection
    public static class MyBean {
        public static String sayHello(String body) {
            return "Hello " + body + " from the MyBean";
        }
    }
}

