/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.bean;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Produce;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.bean.BeanRoutes;
import org.apache.camel.quarkus.component.bean.Counter;
import org.apache.camel.quarkus.component.bean.EagerAppScopedRouteBuilder;
import org.apache.camel.quarkus.component.bean.cdi.Producers;
import org.apache.camel.quarkus.component.bean.model.Employee;

@Path(value="/bean")
@ApplicationScoped
public class BeanResource {
    @Inject
    ProducerTemplate template;
    @Inject
    Counter counter;
    @Inject
    EagerAppScopedRouteBuilder routeBuilder;
    @Inject
    CamelContext camelContext;
    @Produce(value="direct:produceInterface")
    ProduceInterface produceInterface;
    @Inject
    @Named(value="collected-names")
    Map<String, List<String>> collectedNames;

    @Path(value="/route/{route}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String route(String statement, @PathParam(value="route") String route) {
        return (String)this.template.requestBody("direct:" + route, (Object)statement, String.class);
    }

    @Path(value="/route/{route}")
    @GET
    @Produces(value={"text/plain"})
    public String route(@PathParam(value="route") String route) {
        return (String)this.template.requestBody("direct:" + route, null, String.class);
    }

    @Path(value="/beanMethodInHeader")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String beanMethodInHeader(String statement) {
        return (String)this.template.requestBodyAndHeader("direct:named", (Object)statement, "CamelBeanMethodName", (Object)"hi", String.class);
    }

    @Path(value="/counter")
    @GET
    @Produces(value={"text/plain"})
    public int counter() {
        return this.counter.getValue();
    }

    @Path(value="/route-builder-instance-counter")
    @GET
    @Produces(value={"text/plain"})
    public int routeBuilderInstanceCounter() {
        return EagerAppScopedRouteBuilder.INSTANCE_COUNTER.get();
    }

    @Path(value="/route-builder-configure-counter")
    @GET
    @Produces(value={"text/plain"})
    public int routeBuilderConfigureCounter() {
        return EagerAppScopedRouteBuilder.CONFIGURE_COUNTER.get();
    }

    @Path(value="/route-builder-injected-count")
    @GET
    @Produces(value={"text/plain"})
    public int routeBuilderInjectedCount() {
        return this.routeBuilder.getCounter().getValue();
    }

    @Path(value="/camel-configure-counter")
    @GET
    @Produces(value={"text/plain"})
    public int lazyConfigureCounter() {
        return BeanRoutes.CONFIGURE_COUNTER.get();
    }

    @Path(value="/employee/{route}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public String methodWithExchangeArg(Employee employee, @PathParam(value="route") String route) {
        return (String)this.template.requestBody("direct:" + route, (Object)employee, String.class);
    }

    @Path(value="/parameterBindingAnnotations/{greeting}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String parameterBindingAnnotations(String statement, @PathParam(value="greeting") String greeting) {
        return (String)this.template.requestBodyAndHeader("direct:parameterBindingAnnotations", (Object)statement, "parameterBinding.greeting", (Object)greeting, String.class);
    }

    @Path(value="/produceInterface")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String produceInterface(String payload) {
        return this.produceInterface.sayHello(payload);
    }

    String awaitFirst(String key) {
        List<String> list = this.collectedNames.get(key);
        long timeout = System.currentTimeMillis() + 10000L;
        do {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        } while (list.isEmpty() && System.currentTimeMillis() < timeout);
        return list.get(0);
    }

    @Path(value="/withDefaultBeanCount")
    @GET
    @Produces(value={"application/json"})
    public Set<String> withDefaultBean() {
        return this.camelContext.getRegistry().findByType(Producers.WithDefaultBeanInstance.class).stream().map(b -> b.getName()).collect(Collectors.toSet());
    }

    @Path(value="/withAlternativeBeanCount")
    @GET
    @Produces(value={"application/json"})
    public Set<String> withAlternativeBean() {
        return this.camelContext.getRegistry().findByType(Producers.WithAlternateBeanInstance.class).stream().map(b -> b.getName()).collect(Collectors.toSet());
    }

    @Path(value="/withoutDefaultBeans")
    @GET
    @Produces(value={"application/json"})
    public Set<String> withoutDefaultBeans() {
        return this.camelContext.getRegistry().findByType(Producers.WithoutDefaultBeanInstance.class).stream().map(b -> b.getName()).collect(Collectors.toSet());
    }

    @Path(value="/allBeanInstances")
    @GET
    @Produces(value={"application/json"})
    public Set<String> withAllBeanInstances() {
        return this.camelContext.getRegistry().findByType(Producers.BeanInstance.class).stream().map(b -> b.getName()).collect(Collectors.toSet());
    }

    public static interface ProduceInterface {
        public String sayHello(String var1);
    }
}

