/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.bean;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.bean.model.Employee;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class BeanTest {
    @Test
    public void testRoutes() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("nuts@bolts").post("/bean/route/process-order", new Object[0])).then()).body(Matchers.equalTo((Object)"{success=true, lines=[(id=1,item=nuts), (id=2,item=bolts)]}"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/bean/camel-configure-counter", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"1"), new Matcher[0]);
    }

    @Test
    public void named() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Kermit").post("/bean/route/named", new Object[0])).then()).body(Matchers.equalTo((Object)"Hello Kermit from the NamedBean"), new Matcher[0]);
    }

    @Test
    public void beanMethodInHeader() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Kermit").post("/bean/beanMethodInHeader", new Object[0])).then()).body(Matchers.equalTo((Object)"Hi Kermit from the NamedBean"), new Matcher[0]);
    }

    @Test
    public void method() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Kermit").post("/bean/route/method", new Object[0])).then()).body(Matchers.equalTo((Object)"Hello Kermit from the MyBean"), new Matcher[0]);
    }

    @Test
    public void handler() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Kermit").post("/bean/route/handler", new Object[0])).then()).body(Matchers.equalTo((Object)"Hello Kermit from the WithHandlerBean"), new Matcher[0]);
    }

    @Test
    public void handlerWithProxy() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Kermit").post("/bean/route/handlerOnProxy", new Object[0])).then()).body(Matchers.equalTo((Object)"Hello Kermit from the WithHandlerBean"), new Matcher[0]);
    }

    @Test
    public void inject() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/bean/counter", new Object[0])).then()).body(Matchers.equalTo((Object)"0"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.when().get("/bean/route-builder-injected-count", new Object[0])).then()).body(Matchers.equalTo((Object)"0"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.when().get("/bean/route/increment", new Object[0])).then()).body(Matchers.equalTo((Object)"1"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.when().get("/bean/counter", new Object[0])).then()).body(Matchers.equalTo((Object)"1"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.when().get("/bean/route-builder-injected-count", new Object[0])).then()).body(Matchers.equalTo((Object)"1"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.when().get("/bean/route/increment", new Object[0])).then()).body(Matchers.equalTo((Object)"2"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.when().get("/bean/counter", new Object[0])).then()).body(Matchers.equalTo((Object)"2"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.when().get("/bean/route-builder-injected-count", new Object[0])).then()).body(Matchers.equalTo((Object)"2"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/bean/route/config-property", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"myFooValue = foo"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/bean/route-builder-instance-counter", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"1"), new Matcher[0]);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.when().get("/bean/route-builder-configure-counter", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)"1"), new Matcher[0]);
    }

    @Test
    public void lazy() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/bean/route/lazy", new Object[0])).then()).body(Matchers.equalTo((Object)"lazy"), new Matcher[0]);
    }

    @Test
    public void withProducer() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/bean/route/with-producer", new Object[0])).then()).body(Matchers.equalTo((Object)"with-producer"), new Matcher[0]);
    }

    @Test
    public void withLanguageParamBindings() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/bean/route/with-language-param-bindings", new Object[0])).then()).body(Matchers.equalTo((Object)"wlpb-hello(wlpb-route-31wp,cflap-bean-31wp)"), new Matcher[0]);
    }

    @Test
    public void methodWithExchangeArg() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)new Employee("Joe", "Doe", "senior")).post("/bean/employee/methodWithExchangeArg", new Object[0])).then()).body(Matchers.equalTo((Object)"Hello Joe"), new Matcher[0]);
    }

    @Test
    public void completionStageBean() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Franz").post("/bean/route/completionStageBean", new Object[0])).then()).body(Matchers.equalTo((Object)"Hello Franz from CompletionStageBean"), new Matcher[0]);
    }

    @Test
    public void multiArgMethod() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Max").post("/bean/route/multiArgMethod", new Object[0])).then()).body(Matchers.equalTo((Object)"Hello Max from multiArgMethod: got exchange got registry"), new Matcher[0]);
    }

    @Test
    public void parameterBindingAnnotations() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Umberto").post("/bean/parameterBindingAnnotations/Ciao", new Object[0])).then()).body(Matchers.equalTo((Object)"Ciao Umberto from parameterBindingAnnotations"), new Matcher[0]);
    }

    @Test
    public void parameterLiterals() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("Leon").post("/bean/route/parameterLiterals", new Object[0])).then()).body(Matchers.equalTo((Object)"Hello Leon from parameterLiterals(*, true)"), new Matcher[0]);
    }

    @Test
    public void parameterTypes() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)new Employee("Joe", "Doe", "senior")).post("/bean/employee/parameterTypes", new Object[0])).then()).body(Matchers.equalTo((Object)"employeeAsString: Employee [firstName=Joe, lastName=Doe, seniority=senior]"), new Matcher[0]);
    }

    @Test
    public void produceInterface() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("xyz1234").post("/bean/produceInterface", new Object[0])).then()).body(Matchers.equalTo((Object)"produceInterface xyz1234"), new Matcher[0]);
    }
}

