/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.bean;

import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.camel.CamelContext;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.quarkus.component.bean.Counter;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class EagerAppScopedRouteBuilder
extends RouteBuilder {
    static final AtomicInteger INSTANCE_COUNTER = new AtomicInteger(0);
    static final AtomicInteger CONFIGURE_COUNTER = new AtomicInteger(0);
    @Inject
    Counter counter;
    @ConfigProperty(name="my.foo.property", defaultValue="not found")
    String myFooValue;

    @PostConstruct
    public void postConstruct() {
        INSTANCE_COUNTER.incrementAndGet();
    }

    public void addRoutesToCamelContext(CamelContext context) throws Exception {
        CONFIGURE_COUNTER.incrementAndGet();
        super.addRoutesToCamelContext(context);
    }

    public void configure() {
        ((RouteDefinition)((RouteDefinition)this.from("direct:counter").id("counter")).setBody(() -> this.counter.increment())).to("log:counter");
        ((RouteDefinition)((RouteDefinition)this.from("direct:config-property").id("config-property")).setBody(() -> "myFooValue = " + this.myFooValue)).to("log:config-property");
    }

    public Counter getCounter() {
        return this.counter;
    }
}

