/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.bean;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.bean.CamelRoute;
import org.apache.camel.quarkus.component.bean.Counter;
import org.apache.camel.quarkus.component.bean.EagerAppScopedRouteBuilder;

@Path(value="/bean")
@ApplicationScoped
public class CamelResource {
    @Inject
    ProducerTemplate template;
    @Inject
    Counter counter;
    @Inject
    EagerAppScopedRouteBuilder routeBuilder;

    @Path(value="/process-order")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String processOrder(String statement) {
        return (String)this.template.requestBody("direct:process-order", (Object)statement, String.class);
    }

    @Path(value="/increment")
    @GET
    @Produces(value={"text/plain"})
    public String increment() {
        return (String)this.template.requestBody("direct:counter", null, String.class);
    }

    @Path(value="/counter")
    @GET
    @Produces(value={"text/plain"})
    public int counter() {
        return this.counter.getValue();
    }

    @Path(value="/config-property")
    @GET
    @Produces(value={"text/plain"})
    public String configProperty() {
        return (String)this.template.requestBody("direct:config-property", null, String.class);
    }

    @Path(value="/route-builder-instance-counter")
    @GET
    @Produces(value={"text/plain"})
    public int routeBuilderInstanceCounter() {
        return EagerAppScopedRouteBuilder.INSTANCE_COUNTER.get();
    }

    @Path(value="/route-builder-configure-counter")
    @GET
    @Produces(value={"text/plain"})
    public int routeBuilderConfigureCounter() {
        return EagerAppScopedRouteBuilder.CONFIGURE_COUNTER.get();
    }

    @Path(value="/route-builder-injected-count")
    @GET
    @Produces(value={"text/plain"})
    public int routeBuilderInjectedCount() {
        return this.routeBuilder.getCounter().getValue();
    }

    @Path(value="/lazy")
    @GET
    @Produces(value={"text/plain"})
    public String lazy() {
        return (String)this.template.requestBody("direct:lazy", null, String.class);
    }

    @Path(value="/camel-configure-counter")
    @GET
    @Produces(value={"text/plain"})
    public int lazyConfigureCounter() {
        return CamelRoute.CONFIGURE_COUNTER.get();
    }

    @Path(value="/with-producer")
    @GET
    @Produces(value={"text/plain"})
    public String withProducer() {
        return (String)this.template.requestBody("direct:with-producer", null, String.class);
    }
}

