/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.bean.validator.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.bean.validator.it.ValidatorFactoryCustomizer;
import org.apache.camel.quarkus.component.bean.validator.it.model.Car;
import org.jboss.logging.Logger;

@Path(value="/bean-validator")
@ApplicationScoped
public class BeanValidatorResource {
    private static final Logger LOG = Logger.getLogger(BeanValidatorResource.class);
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ValidatorFactoryCustomizer.MyMessageInterpolator messageInterpolator;

    @Path(value="/get/{optional}/{manufactor}/{plate}")
    @GET
    @Produces(value={"text/plain"})
    public Response get(@PathParam(value="optional") String endpoint, @PathParam(value="manufactor") String manufactor, @PathParam(value="plate") String plate) throws Exception {
        return this.get(new Car(manufactor, plate), endpoint);
    }

    @Path(value="/get/{optional}/{manufactor}")
    @GET
    @Produces(value={"text/plain"})
    public Response getNull(@PathParam(value="optional") String endpoint, @PathParam(value="manufactor") String manufactor) throws Exception {
        return this.get(new Car(manufactor, null), endpoint);
    }

    private Response get(Car car, String endpoint) throws Exception {
        LOG.info((Object)("bean-validator: " + car.getManufacturer() + "/" + car.getLicensePlate()));
        Exchange out = this.producerTemplate.request("direct:" + endpoint, e -> e.getMessage().setBody((Object)car));
        if (this.messageInterpolator.getCount() == 0) {
            return Response.status((int)500, (String)"Interpolator was not used.").build();
        }
        if (out.isFailed()) {
            return Response.status((int)400, (String)"Invalid car").build();
        }
        return Response.status((int)200, (String)"OK").build();
    }
}

