/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.bean.validator.it;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.component.bean.validator.it.model.Car;
import org.jboss.logging.Logger;

@Path(value="/bean-validator")
@ApplicationScoped
public class BeanValidatorResource {
    private static final Logger LOG = Logger.getLogger(BeanValidatorResource.class);
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/get/{manufactor}/{plate}")
    @GET
    @Produces(value={"text/plain"})
    public Response get(@PathParam(value="manufactor") String manufactor, @PathParam(value="plate") String plate) throws Exception {
        LOG.info((Object)("bean-validator: " + manufactor + "/" + plate));
        Car car = new Car(manufactor, plate);
        Exchange out = this.producerTemplate.request("direct:start", e -> e.getMessage().setBody((Object)car));
        if (out.isFailed()) {
            return Response.status((int)400, (String)"Invalid car").build();
        }
        return Response.status((int)200, (String)"OK").build();
    }
}

