/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.base64.it;

import java.net.URI;
import java.util.Locale;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;

@Path(value="/base64")
@ApplicationScoped
public class Base64Resource {
    private static final Logger LOG = Logger.getLogger(Base64Resource.class);
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/post")
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"text/plain"})
    public Response post(String message) throws Exception {
        LOG.infof("Sending to base64: %s", (Object)message);
        String response = (String)this.producerTemplate.requestBody("direct:start", (Object)message, String.class);
        LOG.infof("Got response from base64: %s", (Object)response);
        LOG.warn((Object)("Default locale " + Locale.getDefault()));
        for (Locale l : Locale.getAvailableLocales()) {
            LOG.warn((Object)("-- avail locale " + l));
        }
        LOG.warn((Object)("de-de " + String.format(Locale.GERMANY, "%.8f,%.8f", 0.1, 0.1)));
        LOG.warn((Object)("US " + String.format(Locale.US, "%.8f,%.8f", 0.1, 0.1)));
        LOG.warn((Object)("ENGLISH" + String.format(Locale.ENGLISH, "%.8f,%.8f", 0.1, 0.1)));
        LOG.warn((Object)("root " + String.format(Locale.ROOT, "%.8f,%.8f", 0.1, 0.1)));
        return Response.created((URI)new URI("https://camel.apache.org/")).header("content-length", (Object)response.length()).entity((Object)response).build();
    }
}

