/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.azure.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class AzureTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureTestResource.class);
    private static final String AZURITE_IMAGE = "mcr.microsoft.com/azure-storage/azurite:3.6.0";
    private static final String AZURITE_CREDENTIALS = "DefaultEndpointsProtocol=http;AccountName=devstoreaccount1;AccountKey=Eby8vdM02xNOcqFlqUwJPLlmEtlCDXJ1OUzFT50uSRZ6IFsuFq2UVErCz4I6tq/K1SZFPTOtr/KBHBeksoGMGw==;BlobEndpoint=%s;QueueEndpoint=%s;";
    private static final int BLOB_SERVICE_PORT = 10000;
    private static final int QUEUE_SERVICE_PORT = 10001;
    private GenericContainer<?> container;

    public Map<String, String> start() {
        try {
            this.container = new GenericContainer(AZURITE_IMAGE).withExposedPorts(new Integer[]{10000, 10001}).withLogConsumer((Consumer)new Slf4jLogConsumer(LOGGER)).waitingFor((WaitStrategy)Wait.forListeningPort());
            this.container.start();
            String baseServiceUrl = "http://%s:%d/devstoreaccount1/";
            String blobServiceUrl = String.format(baseServiceUrl, this.container.getContainerIpAddress(), this.container.getMappedPort(10000));
            String queueServiceUrl = String.format(baseServiceUrl, this.container.getContainerIpAddress(), this.container.getMappedPort(10001));
            HashMap<String, String> configuration = new HashMap<String, String>();
            configuration.put("azurite.blob.service.url", blobServiceUrl);
            configuration.put("azurite.queue.service.url", queueServiceUrl);
            configuration.put("azurite.credentials", String.format(AZURITE_CREDENTIALS, blobServiceUrl, queueServiceUrl));
            return configuration;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

