/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.azure.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.camel.quarkus.component.azure.it.AzureTestResource;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=AzureTestResource.class)
class AzureTest {
    AzureTest() {
    }

    @Test
    public void testAzureBlobComponent() {
        String blobContent = "Hello Camel Quarkus Azure Blob";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(blobContent).post("/azure/blob/create", new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/azure/blob/read", (Object[])new Object[0]).then()).statusCode(200)).body(Is.is((Object)blobContent), new Matcher[0]);
        String updatedContent = blobContent + " updated";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(updatedContent).patch("/azure/blob/update", new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/azure/blob/read", (Object[])new Object[0]).then()).statusCode(200)).body(Is.is((Object)updatedContent), new Matcher[0]);
        ((ValidatableResponse)RestAssured.delete((String)"/azure/blob/delete", (Object[])new Object[0]).then()).statusCode(204);
    }

    @Test
    public void testAzureQueueComponent() {
        String message = "Hello Camel Quarkus Azure Queue";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).post("/azure/queue/create", new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(message).post("/azure/queue/message", new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/azure/queue/read", (Object[])new Object[0]).then()).statusCode(200)).body(Is.is((Object)message), new Matcher[0]);
        ((ValidatableResponse)RestAssured.delete((String)"/azure/queue/delete", (Object[])new Object[0]).then()).statusCode(204);
    }
}

