/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.azure.storage.blob.it;

import com.azure.core.http.rest.PagedIterable;
import com.azure.storage.blob.changefeed.models.BlobChangefeedEventType;
import com.azure.storage.blob.models.BlobContainerItem;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.Block;
import com.azure.storage.blob.models.BlockList;
import com.azure.storage.blob.models.BlockListType;
import com.azure.storage.blob.models.PageRange;
import com.azure.storage.blob.models.PageRangeItem;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.azure.storage.blob.BlobBlock;
import org.apache.camel.quarkus.core.util.FileUtils;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Path(value="/azure-storage-blob")
@ApplicationScoped
public class AzureStorageBlobResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;
    @Inject
    CamelContext context;
    @ConfigProperty(name="azure.storage.account-name")
    public String azureStorageAccountName;
    @ConfigProperty(name="azure.blob.container.name")
    public String azureBlobContainerName;

    @Path(value="/blob/create")
    @POST
    @Consumes(value={"text/plain"})
    public Response createBlob(final String content) throws Exception {
        Exchange exchange = this.producerTemplate.request("direct:create", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.getMessage().setBody((Object)content);
            }
        });
        if (!exchange.isFailed()) {
            Message message = exchange.getMessage();
            return Response.created((URI)new URI("https://camel.apache.org/")).entity(message.getHeader("CamelAzureStorageBlobETag")).build();
        }
        return Response.serverError().build();
    }

    @Path(value="/blob/read")
    @GET
    @Produces(value={"text/plain"})
    public String readBlob(@QueryParam(value="containerName") String containerName, @QueryParam(value="uri") String uri) {
        if (containerName == null) {
            containerName = this.azureBlobContainerName;
        }
        if (uri == null) {
            uri = "direct:read";
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelCharsetName", StandardCharsets.UTF_8.name());
        headers.put("CamelAzureStorageBlobBlobContainerName", containerName);
        return (String)this.producerTemplate.requestBodyAndHeaders(uri, null, headers, String.class);
    }

    @Path(value="/blob/read/bytes")
    @GET
    @Produces(value={"application/octet-stream"})
    public byte[] readBlobBytes() {
        return (byte[])this.producerTemplate.requestBodyAndHeader("direct:read", null, "CamelCharsetName", (Object)StandardCharsets.UTF_8.name(), byte[].class);
    }

    @Path(value="/blob/list")
    @GET
    @Produces(value={"application/json"})
    public JsonObject listBlobs() {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        List blobs = (List)this.producerTemplate.requestBody("direct:list", null, List.class);
        blobs.stream().map(blobItem -> objectBuilder.add("name", blobItem.getName())).forEach(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
        objectBuilder.add("blobs", arrayBuilder);
        return objectBuilder.build();
    }

    @Path(value="/blob/update")
    @PATCH
    @Consumes(value={"text/plain"})
    public Response updateBlob(String message) {
        this.producerTemplate.sendBody("direct:update", (Object)message);
        return Response.ok().build();
    }

    @Path(value="/blob/delete")
    @DELETE
    public Response deleteBlob() {
        block2: {
            try {
                this.producerTemplate.sendBody("direct:delete", null);
            }
            catch (CamelExecutionException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof BlobStorageException)) break block2;
                BlobStorageException bse = (BlobStorageException)cause;
                return Response.status((int)bse.getStatusCode()).build();
            }
        }
        return Response.noContent().build();
    }

    @Path(value="/blob/download")
    @GET
    public Response downloadBlob() {
        File file = (File)this.producerTemplate.requestBody("direct:download", null, File.class);
        String downloadPath = FileUtils.nixifyPath((String)file.getAbsolutePath());
        return Response.ok((Object)downloadPath).build();
    }

    @Path(value="/blob/download/link")
    @GET
    public Response downloadLink() {
        String link = (String)this.producerTemplate.requestBody("direct:downloadLink", null, String.class);
        return Response.ok((Object)link).build();
    }

    @Path(value="/block/blob/create")
    @POST
    @Consumes(value={"text/plain"})
    public Response createBlockBlob(String content) throws Exception {
        this.producerTemplate.sendBody("direct:uploadBlockBlob", (Object)content);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/blob/block/list")
    @GET
    @Produces(value={"application/json"})
    public JsonObject readBlobBlockList(@QueryParam(value="blockListType") String blockListType) {
        BlockListType listType = BlockListType.valueOf((String)blockListType.toUpperCase());
        BlockList list = (BlockList)this.producerTemplate.requestBodyAndHeader("direct:readBlobBlocks", null, "CamelAzureStorageBlobBlockListType", (Object)listType, BlockList.class);
        JsonObjectBuilder builder = Json.createObjectBuilder();
        if (listType.equals((Object)BlockListType.ALL) || listType.equals((Object)BlockListType.UNCOMMITTED)) {
            this.extractBlockNames(builder, list.getUncommittedBlocks(), BlockListType.UNCOMMITTED);
        }
        if (listType.equals((Object)BlockListType.ALL) || listType.equals((Object)BlockListType.COMMITTED)) {
            this.extractBlockNames(builder, list.getCommittedBlocks(), BlockListType.COMMITTED);
        }
        return builder.build();
    }

    @Path(value="/block/blob/stage")
    @POST
    @Consumes(value={"application/json"})
    public Boolean stageBlockBlobs(List<String> blockContent) {
        List blocks = blockContent.stream().map(String::getBytes).map(ByteArrayInputStream::new).map(inputStream -> {
            try {
                return BlobBlock.createBlobBlock((InputStream)inputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        return (Boolean)this.producerTemplate.requestBody("direct:stageBlockBlob", blocks, Boolean.class);
    }

    @Path(value="/block/blob/commit")
    @POST
    @Consumes(value={"application/json"})
    public Boolean commitBlockBlobs(List<String> blockNames) {
        List blocks = blockNames.stream().map(name -> {
            Block block = new Block();
            block.setName(name);
            return block;
        }).collect(Collectors.toList());
        return (Boolean)this.producerTemplate.requestBody("direct:commitBlockBlob", blocks, Boolean.class);
    }

    @Path(value="/append/blob/create")
    @POST
    @Consumes(value={"text/plain"})
    public Response createAppendBlob(String content) throws URISyntaxException {
        this.producerTemplate.sendBody("direct:createAppendBlob", (Object)content);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/append/blob/commit")
    @POST
    @Produces(value={"text/plain"})
    public Boolean commitAppendBlob(String contentToAppend) {
        byte[] bytes = contentToAppend.getBytes(StandardCharsets.UTF_8);
        return (Boolean)this.producerTemplate.requestBody("direct:commitAppendBlob", (Object)new ByteArrayInputStream(bytes), Boolean.class);
    }

    @Path(value="/page/blob/create")
    @POST
    public Response createPageBlob() throws URISyntaxException {
        this.producerTemplate.sendBody("direct:createPageBlob", null);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/page/blob/upload")
    @POST
    @Produces(value={"text/plain"})
    public Boolean uploadPageBlob(@QueryParam(value="pageStart") int start, @QueryParam(value="pageEnd") int end) {
        byte[] dataBytes = new byte[end + 1];
        new Random().nextBytes(dataBytes);
        ByteArrayInputStream dataStream = new ByteArrayInputStream(dataBytes);
        PageRange pageRange = new PageRange().setStart((long)start).setEnd((long)end);
        return (Boolean)this.producerTemplate.requestBodyAndHeader("direct:uploadPageBlob", (Object)dataStream, "CamelAzureStorageBlobPageBlobRange", (Object)pageRange, Boolean.class);
    }

    @Path(value="/page/blob/resize")
    @POST
    @Produces(value={"text/plain"})
    public Boolean resizePageBlob(@QueryParam(value="pageStart") int start, @QueryParam(value="pageEnd") int end) {
        PageRange pageRange = new PageRange().setStart((long)start).setEnd((long)end);
        return (Boolean)this.producerTemplate.requestBodyAndHeader("direct:resizePageBlob", null, "CamelAzureStorageBlobPageBlobRange", (Object)pageRange, Boolean.class);
    }

    @Path(value="/page/blob/clear")
    @POST
    @Produces(value={"text/plain"})
    public Boolean clearPageBlob(@QueryParam(value="pageStart") int start, @QueryParam(value="pageEnd") int end) {
        PageRange pageRange = new PageRange().setStart((long)start).setEnd((long)end);
        return (Boolean)this.producerTemplate.requestBodyAndHeader("direct:clearPageBlob", null, "CamelAzureStorageBlobPageBlobRange", (Object)pageRange, Boolean.class);
    }

    @Path(value="/page/blob")
    @GET
    @Produces(value={"application/json"})
    public JsonObject getPageBlobRanges(@QueryParam(value="pageStart") int start, @QueryParam(value="pageEnd") int end) {
        PageRange pageRange = new PageRange().setStart((long)start).setEnd((long)end);
        PagedIterable pageIterable = (PagedIterable)this.producerTemplate.requestBodyAndHeader("direct:getPageBlobRanges", null, "CamelAzureStorageBlobPageBlobRange", (Object)pageRange, PagedIterable.class);
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        pageIterable.stream().map(PageRangeItem.class::cast).map(pr -> Json.createObjectBuilder().add("offset", pr.getRange().getOffset()).add("length", pr.getRange().getLength().longValue()).build()).forEach(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
        objectBuilder.add("ranges", (JsonValue)arrayBuilder.build());
        return objectBuilder.build();
    }

    @Path(value="/blob/container")
    @POST
    public Response createBlobContainer(@QueryParam(value="containerName") String containerName) throws Exception {
        this.producerTemplate.sendBodyAndHeader("direct:createBlobContainer", null, "CamelAzureStorageBlobBlobContainerName", (Object)containerName);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/blob/container")
    @GET
    @Produces(value={"application/json"})
    public JsonObject listBlobContainers() throws Exception {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        List containers = (List)this.producerTemplate.requestBody("direct:listBlobContainers", null, List.class);
        containers.stream().map(BlobContainerItem::getName).filter(containerName -> containerName.startsWith("camel-quarkus")).map(containerName -> Json.createObjectBuilder().add("name", containerName).build()).forEach(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
        objectBuilder.add("containers", (JsonValue)arrayBuilder.build());
        return objectBuilder.build();
    }

    @Path(value="/blob/container")
    @DELETE
    public void deleteBlobContainer(@QueryParam(value="containerName") String containerName) {
        this.producerTemplate.sendBodyAndHeader("direct:deleteBlobContainer", null, "CamelAzureStorageBlobBlobContainerName", (Object)containerName);
    }

    @Path(value="/blob/copy")
    @POST
    @Produces(value={"text/plain"})
    public Response copyBlob(@QueryParam(value="containerName") String containerName) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelAzureStorageBlobBlobContainerName", containerName);
        headers.put("CamelAzureStorageBlobBlobName", "test");
        headers.put("CamelAzureStorageBlobSourceBlobContainerName", this.azureBlobContainerName);
        headers.put("CamelAzureStorageBlobSourceBlobAccountName", this.azureStorageAccountName);
        String result = (String)this.producerTemplate.requestBodyAndHeaders("direct:copy", null, headers, String.class);
        return Response.ok((Object)result).build();
    }

    @Path(value="/changes")
    @GET
    @Produces(value={"text/plain"})
    public boolean getChangeFeed(@QueryParam(value="startTime") String startTime, @QueryParam(value="endTime") String endTime, @QueryParam(value="etag") String eTag) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("CamelAzureStorageBlobBlobName", "test");
        headers.put("CamelAzureStorageBlobChangeFeedStartTime", OffsetDateTime.parse(startTime));
        headers.put("CamelAzureStorageBlobChangeFeedEndTime", OffsetDateTime.parse(endTime));
        List events = (List)this.producerTemplate.requestBodyAndHeaders("direct:getChangeFeed", null, headers, List.class);
        if (events == null) {
            return false;
        }
        return events.stream().filter(event -> event.getEventType() != null && event.getEventType().equals((Object)BlobChangefeedEventType.BLOB_CREATED)).anyMatch(event -> event.getData() != null && event.getData().getETag() != null && event.getData().getETag().equals(eTag));
    }

    @Path(value="/consumed/blobs")
    @GET
    @Produces(value={"text/plain"})
    public String getConsumedBlobs() {
        return (String)this.consumerTemplate.receiveBody("seda:blobs", 10000L, String.class);
    }

    @POST
    @Path(value="consumer/{enable}")
    public void mangeBlobConsumer(@PathParam(value="enable") boolean enable) throws Exception {
        if (enable) {
            this.context.getRouteController().startRoute("blob-consumer");
        } else {
            this.context.getRouteController().stopRoute("blob-consumer");
        }
    }

    private void extractBlockNames(JsonObjectBuilder builder, List<Block> blocks, BlockListType listType) {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        blocks.stream().map(Block::getName).forEach(arg_0 -> ((JsonArrayBuilder)arrayBuilder).add(arg_0));
        builder.add(listType.toString(), arrayBuilder);
    }
}

