/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.azure.storage.blob.it;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import jakarta.inject.Named;
import java.io.IOException;
import org.apache.camel.component.azure.storage.blob.BlobComponent;
import org.apache.camel.component.azure.storage.blob.BlobConfiguration;
import org.apache.camel.component.azure.storage.blob.CredentialType;
import org.apache.camel.quarkus.component.azure.storage.blob.it.AzureStorageHelper;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class AzureStorageBlobProducers {
    @ConfigProperty(name="azure.storage.account-name")
    String azureStorageAccountName;
    @ConfigProperty(name="azure.storage.account-key")
    String azureStorageAccountKey;
    @ConfigProperty(name="azure.blob.service.url")
    String azureBlobServiceUrl;

    @Named(value="azureStorageSharedKeyCredential")
    public StorageSharedKeyCredential azureStorageSharedKeyCredential() {
        return new StorageSharedKeyCredential(this.azureStorageAccountName, this.azureStorageAccountKey);
    }

    @Named(value="azureBlobServiceClient")
    public BlobServiceClient createBlobClient(StorageSharedKeyCredential credential) {
        return this.getBlobClientBuilder().credential(credential).buildClient();
    }

    @Named(value="azure-storage-blob-managed-client")
    public BlobComponent azureBlobComponentWithManagedClient() {
        BlobConfiguration configuration = new BlobConfiguration();
        configuration.setCredentialType(CredentialType.SHARED_KEY_CREDENTIAL);
        BlobComponent component = new BlobComponent();
        component.setAutowiredEnabled(false);
        component.setConfiguration(configuration);
        return component;
    }

    @Named(value="azure-storage-blob-client-secret-auth")
    public BlobComponent azureStorageBlobClientSecretAuth() {
        if (AzureStorageHelper.isClientSecretAuthEnabled()) {
            BlobConfiguration configuration = new BlobConfiguration();
            configuration.setCredentialType(CredentialType.AZURE_IDENTITY);
            BlobComponent component = new BlobComponent();
            component.setAutowiredEnabled(false);
            component.setConfiguration(configuration);
            return component;
        }
        return null;
    }

    @Named(value="azure-storage-blob-client-certificate-auth")
    public BlobComponent azureStorageBlobClientCertificateAuth() throws IOException {
        if (AzureStorageHelper.isClientCertificateAuthEnabled()) {
            BlobConfiguration configuration = new BlobConfiguration();
            configuration.setCredentialType(CredentialType.AZURE_IDENTITY);
            BlobComponent component = new BlobComponent();
            component.setAutowiredEnabled(false);
            component.setConfiguration(configuration);
            return component;
        }
        return null;
    }

    private BlobServiceClientBuilder getBlobClientBuilder() {
        return new BlobServiceClientBuilder().endpoint(this.azureBlobServiceUrl).httpLogOptions(new HttpLogOptions().setLogLevel(HttpLogDetailLevel.BODY_AND_HEADERS).setPrettyPrintBody(true));
    }
}

