/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.azure.eventhubs.it;

import com.azure.core.amqp.AmqpTransportType;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Optional;
import org.apache.camel.builder.RouteBuilder;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class AzureEventhubsRoutes
extends RouteBuilder {
    @ConfigProperty(name="azure.storage.account-name")
    String azureStorageAccountName;
    @ConfigProperty(name="azure.storage.account-key")
    String azureStorageAccountKey;
    @ConfigProperty(name="azure.event.hubs.connection.string")
    Optional<String> connectionString;
    @ConfigProperty(name="azure.event.hubs.blob.container.name")
    Optional<String> azureBlobContainerName;
    @ConfigProperty(name="camel.quarkus.start.mock.backend", defaultValue="true")
    boolean startMockBackend;

    public void configure() throws Exception {
        if (this.connectionString.isPresent() && this.azureBlobContainerName.isPresent()) {
            this.from("azure-eventhubs:?connectionString=RAW(" + this.connectionString.get() + ")&blobAccountName=RAW(" + this.azureStorageAccountName + ")&blobAccessKey=RAW(" + this.azureStorageAccountKey + ")&blobContainerName=RAW(" + this.azureBlobContainerName.get() + ")&amqpTransportType=" + AmqpTransportType.AMQP).to("mock:azure-consumed");
        } else if (!this.startMockBackend) {
            throw new IllegalStateException("azure.event.hubs.connection.string and azure.event.hubs.blob.container.name must be set when camel.quarkus.start.mock.backend == false");
        }
    }
}

