/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.azure.storage.queue.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.camel.quarkus.test.support.azure.AzureStorageTestResource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testcontainers.shaded.org.awaitility.Awaitility;

@QuarkusTest
@QuarkusTestResource(value=AzureStorageTestResource.class)
class AzureStorageQueueTest {
    AzureStorageQueueTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void crud() {
        try {
            String message = "Hello Camel Quarkus Azure Queue ";
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).post("/azure-storage-queue/queue/create", new Object[0])).then()).statusCode(201);
            for (int i = 1; i < 2; ++i) {
                this.addMessage(message + i);
            }
            ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/azure-storage-queue/queue/peek", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.is((Object)(message + "1")), new Matcher[0]);
            List<LinkedHashMap<String, String>> response = null;
            for (int i = 1; i < 2; ++i) {
                response = this.readMessage();
                Assertions.assertNotNull(response);
                Assertions.assertEquals((int)1, (int)response.size());
                Assertions.assertNotNull(response.get(0));
                Assertions.assertEquals((Object)(message + i), (Object)response.get(0).get("body"));
            }
            String id = response.get(0).get("id");
            String popReceipt = response.get(0).get("popReceipt");
            message = "Update Camel Quarkus example message";
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(message).post(String.format("/azure-storage-queue/queue/update/%s/%s", id, popReceipt), new Object[0])).then()).statusCode(201);
            response = this.readMessage();
            Assertions.assertNotNull(response);
            Assertions.assertNotNull(response.get(0));
            Assertions.assertEquals((Object)message, (Object)response.get(0).get("body"));
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/azure-storage-queue/queue/list", new Object[0])).then()).statusCode(200)).body(Matchers.containsString((String)"camel-quarkus"), new Matcher[0]);
            this.addMessage(message);
            ((ValidatableResponse)((Response)RestAssured.given().get("/azure-storage-queue/queue/clear", new Object[0])).then()).statusCode(204);
            response = this.readMessage();
            Assertions.assertNotNull(response);
            Assertions.assertEquals((int)0, (int)response.size());
            this.addMessage(message);
            response = this.readMessage();
            id = response.get(0).get("id");
            popReceipt = response.get(0).get("popReceipt");
            ((ValidatableResponse)RestAssured.delete((String)("/azure-storage-queue/queue/delete/" + id + "/" + popReceipt), (Object[])new Object[0]).then()).statusCode(204);
            ((ValidatableResponse)((Response)RestAssured.given().post("/azure-storage-queue/queue/consumer/start", new Object[0])).then()).statusCode(204);
            this.addMessage("Testing consumer");
            Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(10L, TimeUnit.SECONDS).until(() -> {
                String body = ((ValidatableResponse)((Response)RestAssured.given().get("/azure-storage-queue/queue/consumer", new Object[0])).then()).extract().body().asString();
                return body != null && body.contains("Testing consumer");
            });
            ((ValidatableResponse)((Response)RestAssured.given().post("/azure-storage-queue/queue/consumer/stop", new Object[0])).then()).statusCode(204);
        }
        finally {
            ((ValidatableResponse)RestAssured.delete((String)"/azure-storage-queue/queue/delete", (Object[])new Object[0]).then()).statusCode(204);
        }
    }

    private void addMessage(String message) {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(message).post("/azure-storage-queue/queue/message", new Object[0])).then()).statusCode(201);
    }

    private List<LinkedHashMap<String, String>> readMessage() {
        return (List)((Response)RestAssured.given().contentType(ContentType.JSON).when().get("/azure-storage-queue/queue/read", new Object[0])).as(List.class);
    }
}

