/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.azure.storage.blob.it;

import com.azure.storage.blob.models.BlockListType;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.camel.quarkus.component.azure.storage.blob.it.AzureStorageHelper;
import org.apache.camel.quarkus.test.EnabledIf;
import org.apache.camel.quarkus.test.mock.backend.MockBackendDisabled;
import org.apache.camel.quarkus.test.support.azure.AzureStorageTestResource;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.StringEndsWith;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.testcontainers.shaded.org.awaitility.Awaitility;

@QuarkusTest
@QuarkusTestResource(value=AzureStorageTestResource.class)
class AzureStorageBlobTest {
    private static final String BLOB_CONTENT = "Hello Camel Quarkus Azure Blob";

    AzureStorageBlobTest() {
    }

    @BeforeAll
    static void beforeAll() {
        int port;
        Config config = ConfigProvider.getConfig();
        String containerName = (String)config.getValue("azure.blob.container.name", String.class);
        RestAssured.port = port = ((Integer)config.getValue("quarkus.http.test-port", Integer.TYPE)).intValue();
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("containerName", new Object[]{containerName}).post("/azure-storage-blob/blob/container", new Object[0])).then()).statusCode(201);
    }

    @AfterAll
    static void afterAll() {
        Config config = ConfigProvider.getConfig();
        String containerName = (String)config.getValue("azure.blob.container.name", String.class);
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("containerName", new Object[]{containerName}).delete("/azure-storage-blob/blob/container", new Object[0])).then()).statusCode(204);
    }

    @Test
    public void crud() {
        try {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(BLOB_CONTENT).post("/azure-storage-blob/blob/create", new Object[0])).then()).statusCode(201);
            ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/azure-storage-blob/blob/read", (Object[])new Object[0]).then()).statusCode(200)).body(Is.is((Object)BLOB_CONTENT), new Matcher[0]);
            ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/azure-storage-blob/blob/list", (Object[])new Object[0]).then()).statusCode(200)).body("blobs[0].name", Is.is((Object)"test"), new Object[0]);
            String updatedContent = "Hello Camel Quarkus Azure Blob updated";
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(updatedContent).patch("/azure-storage-blob/blob/update", new Object[0])).then()).statusCode(200);
            ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/azure-storage-blob/blob/read", (Object[])new Object[0]).then()).statusCode(200)).body(Is.is((Object)updatedContent), new Matcher[0]);
        }
        finally {
            ((ValidatableResponse)RestAssured.delete((String)"/azure-storage-blob/blob/delete", (Object[])new Object[0]).then()).statusCode((Matcher)Matchers.anyOf((Matcher)Is.is((Object)204), (Matcher)Is.is((Object)404)));
        }
    }

    @Test
    public void download() throws IOException {
        block7: {
            Path path = null;
            try {
                ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(BLOB_CONTENT).post("/azure-storage-blob/blob/create", new Object[0])).then()).statusCode(201);
                String downloadPath = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/azure-storage-blob/blob/download", (Object[])new Object[0]).then()).statusCode(200)).body(StringEndsWith.endsWith((String)"target/test"), new Matcher[0])).extract().body().asString();
                path = Paths.get(downloadPath, new String[0]);
                Assertions.assertEquals((Object)BLOB_CONTENT, (Object)Files.readString(path));
                ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/azure-storage-blob/blob/download/link", (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.matchesPattern((String)"^(https?)://.*/test.*"), new Matcher[0]);
                if (path == null) break block7;
            }
            catch (Throwable throwable) {
                if (path != null) {
                    try {
                        Files.deleteIfExists(path);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                ((ValidatableResponse)RestAssured.delete((String)"/azure-storage-blob/blob/delete", (Object[])new Object[0]).then()).statusCode((Matcher)Matchers.anyOf((Matcher)Is.is((Object)204), (Matcher)Is.is((Object)404)));
                throw throwable;
            }
            try {
                Files.deleteIfExists(path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ((ValidatableResponse)RestAssured.delete((String)"/azure-storage-blob/blob/delete", (Object[])new Object[0]).then()).statusCode((Matcher)Matchers.anyOf((Matcher)Is.is((Object)204), (Matcher)Is.is((Object)404)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void blockBlobStageCommit() {
        try {
            List<String> blockContent = Arrays.asList(BLOB_CONTENT.split(" "));
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(blockContent).post("/azure-storage-blob/block/blob/stage", new Object[0])).then()).statusCode(200)).body(Is.is((Object)"true"), new Matcher[0]);
            JsonPath json = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("blockListType", new Object[]{BlockListType.UNCOMMITTED}).get("/azure-storage-blob/blob/block/list", new Object[0])).then()).statusCode(200)).extract().body().jsonPath();
            List uncommittedBlocks = json.getList(BlockListType.UNCOMMITTED.toString());
            Assertions.assertNotNull((Object)uncommittedBlocks);
            Assertions.assertEquals((int)blockContent.size(), (int)uncommittedBlocks.size());
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)uncommittedBlocks).post("/azure-storage-blob/block/blob/commit", new Object[0])).then()).statusCode(200)).body(Is.is((Object)"true"), new Matcher[0]);
            json = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("blockListType", new Object[]{BlockListType.COMMITTED}).get("/azure-storage-blob/blob/block/list", new Object[0])).then()).statusCode(200)).extract().body().jsonPath();
            List committedBlocks = json.getList(BlockListType.COMMITTED.toString());
            Assertions.assertNotNull((Object)committedBlocks);
            Assertions.assertEquals((int)blockContent.size(), (int)committedBlocks.size());
        }
        finally {
            ((ValidatableResponse)RestAssured.delete((String)"/azure-storage-blob/blob/delete", (Object[])new Object[0]).then()).statusCode((Matcher)Matchers.anyOf((Matcher)Is.is((Object)204), (Matcher)Is.is((Object)404)));
        }
    }

    @Test
    public void appendBlob() {
        try {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(BLOB_CONTENT).post("/azure-storage-blob/append/blob/create", new Object[0])).then()).statusCode(201);
            String appendedContent = "Hello Camel Quarkus Azure Blob Appended";
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(appendedContent).post("/azure-storage-blob/append/blob/commit", new Object[0])).then()).statusCode(200)).body(Is.is((Object)"true"), new Matcher[0]);
            ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/azure-storage-blob/blob/read", (Object[])new Object[0]).then()).statusCode(200)).body(Is.is((Object)appendedContent), new Matcher[0]);
        }
        finally {
            ((ValidatableResponse)RestAssured.delete((String)"/azure-storage-blob/blob/delete", (Object[])new Object[0]).then()).statusCode((Matcher)Matchers.anyOf((Matcher)Is.is((Object)204), (Matcher)Is.is((Object)404)));
        }
    }

    @Test
    public void pageBlob() {
        try {
            int i;
            ((ValidatableResponse)((Response)RestAssured.given().post("/azure-storage-blob/page/blob/create", new Object[0])).then()).statusCode(201);
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("pageStart", new Object[]{0}).queryParam("pageEnd", new Object[]{511}).post("/azure-storage-blob/page/blob/upload", new Object[0])).then()).statusCode(200)).body(Is.is((Object)"true"), new Matcher[0]);
            byte[] pageData = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/azure-storage-blob/blob/read/bytes", (Object[])new Object[0]).then()).statusCode(200)).extract().body().asByteArray();
            Assertions.assertEquals((int)512, (int)pageData.length);
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("pageStart", new Object[]{0}).queryParam("pageEnd", new Object[]{511}).get("/azure-storage-blob/page/blob", new Object[0])).then()).statusCode(200)).body("ranges[0].offset", Is.is((Object)0), new Object[]{"ranges[0].length", Is.is((Object)512)});
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("pageStart", new Object[]{0}).queryParam("pageEnd", new Object[]{1023}).post("/azure-storage-blob/page/blob/resize", new Object[0])).then()).statusCode(200)).body(Is.is((Object)"true"), new Matcher[0]);
            pageData = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/azure-storage-blob/blob/read/bytes", (Object[])new Object[0]).then()).statusCode(200)).extract().body().asByteArray();
            Assertions.assertEquals((int)1024, (int)pageData.length);
            for (i = 512; i < pageData.length; ++i) {
                if (pageData[i] == 0) continue;
                Assertions.fail((String)("Expected byte element at position " + i + " to be zero value"));
            }
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("pageStart", new Object[]{0}).queryParam("pageEnd", new Object[]{1023}).post("/azure-storage-blob/page/blob/clear", new Object[0])).then()).statusCode(200)).body(Is.is((Object)"true"), new Matcher[0]);
            pageData = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/azure-storage-blob/blob/read/bytes", (Object[])new Object[0]).then()).statusCode(200)).extract().body().asByteArray();
            for (i = 0; i < pageData.length; ++i) {
                if (pageData[i] == 0) continue;
                Assertions.fail((String)("Expected byte element at position " + i + " to be zero value"));
            }
        }
        finally {
            ((ValidatableResponse)RestAssured.delete((String)"/azure-storage-blob/blob/delete", (Object[])new Object[0]).then()).statusCode((Matcher)Matchers.anyOf((Matcher)Is.is((Object)204), (Matcher)Is.is((Object)404)));
        }
    }

    @Test
    public void blobContainer() {
        String alternativeContainerName = "camel-quarkus-" + UUID.randomUUID();
        try {
            ((ValidatableResponse)((Response)RestAssured.given().queryParam("containerName", new Object[]{alternativeContainerName}).post("/azure-storage-blob/blob/container", new Object[0])).then()).statusCode(201);
            String containerName = (String)ConfigProvider.getConfig().getValue("azure.blob.container.name", String.class);
            ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/azure-storage-blob/blob/container", (Object[])new Object[0]).then()).statusCode(200)).body("containers.name", Matchers.hasItems((Object[])new String[]{containerName, alternativeContainerName}), new Object[0]);
        }
        catch (Throwable throwable) {
            ((ValidatableResponse)((Response)RestAssured.given().queryParam("containerName", new Object[]{alternativeContainerName}).delete("/azure-storage-blob/blob/container", new Object[0])).then()).statusCode((Matcher)Matchers.anyOf((Matcher)Is.is((Object)204), (Matcher)Is.is((Object)404)));
            throw throwable;
        }
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("containerName", new Object[]{alternativeContainerName}).delete("/azure-storage-blob/blob/container", new Object[0])).then()).statusCode((Matcher)Matchers.anyOf((Matcher)Is.is((Object)204), (Matcher)Is.is((Object)404)));
    }

    @Test
    public void copyBlob() {
        String alternativeContainerName = "camel-quarkus-" + UUID.randomUUID();
        try {
            ((ValidatableResponse)((Response)RestAssured.given().queryParam("containerName", new Object[]{alternativeContainerName}).post("/azure-storage-blob/blob/container", new Object[0])).then()).statusCode(201);
            String containerName = (String)ConfigProvider.getConfig().getValue("azure.blob.container.name", String.class);
            ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/azure-storage-blob/blob/container", (Object[])new Object[0]).then()).statusCode(200)).body("containers.name", Matchers.hasItems((Object[])new String[]{containerName, alternativeContainerName}), new Object[0]);
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(BLOB_CONTENT).post("/azure-storage-blob/blob/create", new Object[0])).then()).statusCode(201);
            ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/azure-storage-blob/blob/read", (Object[])new Object[0]).then()).statusCode(200)).body(Is.is((Object)BLOB_CONTENT), new Matcher[0]);
            ((ValidatableResponse)((Response)RestAssured.given().queryParam("containerName", new Object[]{alternativeContainerName}).post("/azure-storage-blob/blob/copy", new Object[0])).then()).statusCode(200);
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("containerName", new Object[]{alternativeContainerName}).get("/azure-storage-blob/blob/read", new Object[0])).then()).statusCode(200)).body(Is.is((Object)BLOB_CONTENT), new Matcher[0]);
        }
        catch (Throwable throwable) {
            ((ValidatableResponse)((Response)RestAssured.given().queryParam("containerName", new Object[]{alternativeContainerName}).delete("/azure-storage-blob/blob/container", new Object[0])).then()).statusCode(204);
            ((ValidatableResponse)RestAssured.delete((String)"/azure-storage-blob/blob/delete", (Object[])new Object[0]).then()).statusCode((Matcher)Matchers.anyOf((Matcher)Is.is((Object)204), (Matcher)Is.is((Object)404)));
            throw throwable;
        }
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("containerName", new Object[]{alternativeContainerName}).delete("/azure-storage-blob/blob/container", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)RestAssured.delete((String)"/azure-storage-blob/blob/delete", (Object[])new Object[0]).then()).statusCode((Matcher)Matchers.anyOf((Matcher)Is.is((Object)204), (Matcher)Is.is((Object)404)));
    }

    @Test
    public void blobConsumer() {
        try {
            ((ValidatableResponse)((Response)RestAssured.given().post("/azure-storage-blob/consumer/true", new Object[0])).then()).statusCode(204);
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(BLOB_CONTENT).post("/azure-storage-blob/blob/create", new Object[0])).then()).statusCode(201);
            ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/azure-storage-blob/consumed/blobs", (Object[])new Object[0]).then()).statusCode(200)).body(Is.is((Object)BLOB_CONTENT), new Matcher[0]);
        }
        finally {
            ((ValidatableResponse)((Response)RestAssured.given().post("/azure-storage-blob/consumer/false", new Object[0])).then()).statusCode(204);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EnabledIf(value={MockBackendDisabled.class})
    @Test
    public void changeFeed() {
        try {
            String eTag = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(BLOB_CONTENT).post("/azure-storage-blob/blob/create", new Object[0])).then()).statusCode(201)).extract().body().asString();
            OffsetDateTime now = OffsetDateTime.now();
            OffsetDateTime startTime = now.minus(5L, ChronoUnit.MINUTES);
            OffsetDateTime endTime = now.plus(5L, ChronoUnit.MINUTES);
            Awaitility.await().pollInterval(5L, TimeUnit.SECONDS).timeout(5L, TimeUnit.MINUTES).until(() -> ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("startTime", new Object[]{startTime.toString()}).queryParam("endTime", new Object[]{endTime.toString()}).queryParam("etag", new Object[]{eTag}).get("/azure-storage-blob/changes", new Object[0])).then()).statusCode(200)).extract().body().asString().equals("true"));
        }
        finally {
            ((ValidatableResponse)RestAssured.delete((String)"/azure-storage-blob/blob/delete", (Object[])new Object[0]).then()).statusCode((Matcher)Matchers.anyOf((Matcher)Is.is((Object)204), (Matcher)Is.is((Object)404)));
        }
    }

    @EnabledIf(value={MockBackendDisabled.class})
    @Test
    public void readWithManagedClient() {
        try {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(BLOB_CONTENT).post("/azure-storage-blob/blob/create", new Object[0])).then()).statusCode(201);
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("uri", new Object[]{"direct:readWithManagedClient"}).get("/azure-storage-blob/blob/read", new Object[0])).then()).statusCode(200)).body(Is.is((Object)BLOB_CONTENT), new Matcher[0]);
        }
        finally {
            ((ValidatableResponse)RestAssured.delete((String)"/azure-storage-blob/blob/delete", (Object[])new Object[0]).then()).statusCode((Matcher)Matchers.anyOf((Matcher)Is.is((Object)204), (Matcher)Is.is((Object)404)));
        }
    }

    @EnabledIf(value={AzureStorageHelper.ClientSecretAuthEnabled.class})
    @Test
    public void readWithClientSecretAuth() {
        try {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(BLOB_CONTENT).post("/azure-storage-blob/blob/create", new Object[0])).then()).statusCode(201);
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("uri", new Object[]{"direct:readWithClientSecret"}).get("/azure-storage-blob/blob/read", new Object[0])).then()).statusCode(200)).body(Is.is((Object)BLOB_CONTENT), new Matcher[0]);
        }
        finally {
            ((ValidatableResponse)RestAssured.delete((String)"/azure-storage-blob/blob/delete", (Object[])new Object[0]).then()).statusCode((Matcher)Matchers.anyOf((Matcher)Is.is((Object)204), (Matcher)Is.is((Object)404)));
        }
    }

    @EnabledIf(value={AzureStorageHelper.ClientCertificateAuthEnabled.class})
    @Test
    public void readWithClientCertificateAuth() {
        try {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(BLOB_CONTENT).post("/azure-storage-blob/blob/create", new Object[0])).then()).statusCode(201);
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("uri", new Object[]{"direct:readWithClientCertificate"}).get("/azure-storage-blob/blob/read", new Object[0])).then()).statusCode(200)).body(Is.is((Object)BLOB_CONTENT), new Matcher[0]);
        }
        finally {
            ((ValidatableResponse)RestAssured.delete((String)"/azure-storage-blob/blob/delete", (Object[])new Object[0]).then()).statusCode((Matcher)Matchers.anyOf((Matcher)Is.is((Object)204), (Matcher)Is.is((Object)404)));
        }
    }
}

