/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.azure.eventhubs.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.awaitility.Awaitility;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariables;

@EnabledIfEnvironmentVariables(value={@EnabledIfEnvironmentVariable(named="AZURE_STORAGE_ACCOUNT_NAME", matches=".+"), @EnabledIfEnvironmentVariable(named="AZURE_STORAGE_ACCOUNT_KEY", matches=".+"), @EnabledIfEnvironmentVariable(named="AZURE_EVENT_HUBS_BLOB_CONTAINER_NAME", matches=".+"), @EnabledIfEnvironmentVariable(named="AZURE_EVENT_HUBS_CONNECTION_STRING", matches=".+")})
@QuarkusTest
class AzureEventhubsTest {
    private static final Logger LOG = Logger.getLogger(AzureEventhubsTest.class);

    AzureEventhubsTest() {
    }

    @Test
    public void roundTrip() {
        String messageBody = RandomStringUtils.randomAlphabetic((int)30);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(messageBody).post("/azure-eventhubs/send-events", new Object[0])).then()).statusCode(201);
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            String body = ((ValidatableResponse)((Response)RestAssured.given().get("/azure-eventhubs/receive-events", new Object[0])).then()).extract().body().asString();
            LOG.infof("Expected message body: '%s'; actual: '%s'", (Object)messageBody, (Object)body);
            return body != null && body.contains(messageBody);
        });
    }
}

