/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.azure.storage.queue.it;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.util.BinaryData;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.queue.QueueServiceClient;
import com.azure.storage.queue.QueueServiceClientBuilder;
import com.azure.storage.queue.models.QueueMessageItem;
import java.net.URI;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.azure.storage.queue.QueueOperationDefinition;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Path(value="/azure-storage-queue")
@ApplicationScoped
public class AzureStorageQueueResource {
    private static final String QUEUE_NAME = "camel-quarkus-" + UUID.randomUUID().toString();
    @Inject
    ProducerTemplate producerTemplate;
    @ConfigProperty(name="azure.storage.account-name")
    String azureStorageAccountName;
    @ConfigProperty(name="azure.storage.account-key")
    String azureStorageAccountKey;
    @ConfigProperty(name="azure.queue.service.url")
    String azureQueueServiceUrl;

    @Produces
    public QueueServiceClient createQueueClient() throws Exception {
        StorageSharedKeyCredential credentials = new StorageSharedKeyCredential(this.azureStorageAccountName, this.azureStorageAccountKey);
        return new QueueServiceClientBuilder().endpoint(this.azureQueueServiceUrl).credential(credentials).httpLogOptions(new HttpLogOptions().setLogLevel(HttpLogDetailLevel.BODY_AND_HEADERS).setPrettyPrintBody(true)).buildClient();
    }

    @Path(value="/queue/create")
    @POST
    public Response createQueue() throws Exception {
        this.producerTemplate.sendBody(this.componentUri(QueueOperationDefinition.createQueue), null);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/queue/read")
    @GET
    @javax.ws.rs.Produces(value={"text/plain"})
    public String retrieveMessage() throws Exception {
        List messages = (List)this.producerTemplate.requestBody(this.componentUri(QueueOperationDefinition.receiveMessages), null, List.class);
        return messages.stream().map(QueueMessageItem::getBody).map(BinaryData::toString).collect(Collectors.joining("\n"));
    }

    @Path(value="/queue/message")
    @POST
    @Consumes(value={"text/plain"})
    public Response addMessage(String message) throws Exception {
        this.producerTemplate.sendBody(this.componentUri(QueueOperationDefinition.sendMessage), (Object)message);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/queue/delete")
    @DELETE
    public Response deleteQueue() throws Exception {
        this.producerTemplate.sendBody(this.componentUri(QueueOperationDefinition.deleteQueue), null);
        return Response.noContent().build();
    }

    private String componentUri(QueueOperationDefinition operation) {
        return String.format("azure-storage-queue://%s/%s?operation=%s", this.azureStorageAccountName, QUEUE_NAME, operation.name());
    }
}

