/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.azure.storage.blob.it;

import javax.enterprise.context.ApplicationScoped;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.azure.storage.blob.BlobOperationsDefinition;
import org.apache.camel.model.RouteDefinition;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class AzureStorageBlobRoutes
extends RouteBuilder {
    public static final String BLOB_NAME = "test";
    @ConfigProperty(name="azure.storage.account-name")
    public String azureStorageAccountName;
    @ConfigProperty(name="azure.blob.container.name")
    public String azureBlobContainerName;
    @ConfigProperty(name="azure.storage.account-key")
    public String azureStorageAccountKey;

    public void configure() throws Exception {
        ((RouteDefinition)this.fromF("azure-storage-blob://%s/%s", new Object[]{this.azureStorageAccountName, this.azureBlobContainerName}).id("blob-consumer")).autoStartup(false).to("seda:blobs");
        this.from("direct:create").to(this.componentUri(BlobOperationsDefinition.uploadBlockBlob));
        this.from("direct:read").to(this.componentUri(BlobOperationsDefinition.getBlob));
        this.from("direct:update").to(this.componentUri(BlobOperationsDefinition.uploadBlockBlob));
        this.from("direct:delete").to(this.componentUri(BlobOperationsDefinition.deleteBlob));
        this.from("direct:list").to(this.componentUri(BlobOperationsDefinition.listBlobs));
        this.from("direct:download").to(this.componentUri(BlobOperationsDefinition.downloadBlobToFile) + "&fileDir=target");
        this.from("direct:copy").to(this.componentUri(BlobOperationsDefinition.copyBlob) + "&sourceBlobAccessKey=RAW(" + this.azureStorageAccountKey + ")");
        ((RouteDefinition)this.from("direct:downloadLink").to(this.componentUri(BlobOperationsDefinition.downloadLink))).setBody().header("CamelAzureStorageBlobDownloadLink");
        this.from("direct:uploadBlockBlob").to(this.componentUri(BlobOperationsDefinition.uploadBlockBlob));
        this.from("direct:stageBlockBlob").to(this.componentUri(BlobOperationsDefinition.stageBlockBlobList));
        this.from("direct:commitBlockBlob").to(this.componentUri(BlobOperationsDefinition.commitBlobBlockList));
        this.from("direct:readBlobBlocks").to(this.componentUri(BlobOperationsDefinition.getBlobBlockList));
        this.from("direct:createAppendBlob").to(this.componentUri(BlobOperationsDefinition.createAppendBlob));
        this.from("direct:commitAppendBlob").to(this.componentUri(BlobOperationsDefinition.commitAppendBlob));
        this.from("direct:createPageBlob").to(this.componentUri(BlobOperationsDefinition.createPageBlob));
        this.from("direct:uploadPageBlob").to(this.componentUri(BlobOperationsDefinition.uploadPageBlob));
        this.from("direct:resizePageBlob").to(this.componentUri(BlobOperationsDefinition.resizePageBlob));
        this.from("direct:clearPageBlob").to(this.componentUri(BlobOperationsDefinition.clearPageBlob));
        this.from("direct:getPageBlobRanges").to(this.componentUri(BlobOperationsDefinition.getPageBlobRanges));
        this.from("direct:getChangeFeed").toF(this.componentUri(BlobOperationsDefinition.getChangeFeed), new Object[0]);
        this.from("direct:createBlobContainer").to(this.componentUri(BlobOperationsDefinition.createBlobContainer));
        this.from("direct:listBlobContainers").to(this.componentUri(BlobOperationsDefinition.listBlobContainers));
        this.from("direct:deleteBlobContainer").to(this.componentUri(BlobOperationsDefinition.deleteBlobContainer));
    }

    private String componentUri(BlobOperationsDefinition operation) {
        return String.format("azure-storage-blob://%s/%s?operation=%s&blobName=%s", this.azureStorageAccountName, this.azureBlobContainerName, operation.name(), BLOB_NAME);
    }
}

