/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.azure.storage.blob.it;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import javax.inject.Named;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class AzureStorageBlobProducers {
    @ConfigProperty(name="azure.storage.account-name")
    String azureStorageAccountName;
    @ConfigProperty(name="azure.storage.account-key")
    String azureStorageAccountKey;
    @ConfigProperty(name="azure.blob.service.url")
    String azureBlobServiceUrl;

    @Named(value="azureBlobServiceClient")
    public BlobServiceClient createBlobClient() throws Exception {
        StorageSharedKeyCredential credentials = new StorageSharedKeyCredential(this.azureStorageAccountName, this.azureStorageAccountKey);
        return new BlobServiceClientBuilder().endpoint(this.azureBlobServiceUrl).credential(credentials).httpLogOptions(new HttpLogOptions().setLogLevel(HttpLogDetailLevel.BODY_AND_HEADERS).setPrettyPrintBody(true)).buildClient();
    }
}

