/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.azure.storage.blob.it;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.azure.storage.blob.BlobOperationsDefinition;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Path(value="/azure-storage-blob")
@ApplicationScoped
public class AzureStorageBlobResource {
    private static final String BLOB_NAME = "test";
    @Inject
    ProducerTemplate producerTemplate;
    @ConfigProperty(name="azure.storage.account-name")
    String azureStorageAccountName;
    @ConfigProperty(name="azure.storage.account-key")
    String azureStorageAccountKey;
    @ConfigProperty(name="azure.blob.service.url")
    String azureBlobServiceUrl;
    @ConfigProperty(name="azure.blob.container.name")
    String azureBlobContainerName;

    @Produces
    @Named(value="azureBlobServiceClient")
    public BlobServiceClient createBlobClient() throws Exception {
        StorageSharedKeyCredential credentials = new StorageSharedKeyCredential(this.azureStorageAccountName, this.azureStorageAccountKey);
        return new BlobServiceClientBuilder().endpoint(this.azureBlobServiceUrl).credential(credentials).httpLogOptions(new HttpLogOptions().setLogLevel(HttpLogDetailLevel.BODY_AND_HEADERS).setPrettyPrintBody(true)).buildClient();
    }

    @Path(value="/blob/create")
    @POST
    @Consumes(value={"text/plain"})
    public Response createBlob(String message) throws Exception {
        this.producerTemplate.sendBody(this.componentUri(BlobOperationsDefinition.uploadBlockBlob), (Object)message);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/blob/read")
    @GET
    @javax.ws.rs.Produces(value={"text/plain"})
    public String readBlob() throws Exception {
        return (String)this.producerTemplate.requestBodyAndHeader(this.componentUri(BlobOperationsDefinition.getBlob), null, "CamelCharsetName", (Object)StandardCharsets.UTF_8.name(), String.class);
    }

    @Path(value="/blob/update")
    @PATCH
    @Consumes(value={"text/plain"})
    public Response updateBlob(String message) throws Exception {
        this.producerTemplate.sendBody(this.componentUri(BlobOperationsDefinition.uploadBlockBlob), (Object)message);
        return Response.ok().build();
    }

    @Path(value="/blob/delete")
    @DELETE
    public Response deleteBlob() throws Exception {
        this.producerTemplate.sendBody(this.componentUri(BlobOperationsDefinition.deleteBlob), null);
        return Response.noContent().build();
    }

    private String componentUri(BlobOperationsDefinition operation) {
        return String.format("azure-storage-blob://%s/%s?blobServiceClient=#azureBlobServiceClient&operation=%s&blobName=%s", this.azureStorageAccountName, this.azureBlobContainerName, operation.name(), BLOB_NAME);
    }
}

