/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.azure.eventhubs.it;

import io.quarkus.scheduler.Scheduled;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.mock.MockEndpoint;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Path(value="/azure-eventhubs")
@ApplicationScoped
public class AzureEventhubsResource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;
    @Inject
    CamelContext context;
    @ConfigProperty(name="azure.event.hubs.connection.string")
    Optional<String> connectionString;
    private volatile String message;
    private int counter = 0;

    @Scheduled(every="1s")
    void schedule() {
        if (this.message != null) {
            String endpointUri = "azure-eventhubs:?connectionString=RAW(" + this.connectionString.get() + ")";
            this.producerTemplate.sendBody(endpointUri, (Object)(this.message + this.counter++));
        }
    }

    @Path(value="/receive-events")
    @GET
    @Produces(value={"application/json"})
    public List<String> receiveEvents() throws Exception {
        MockEndpoint mockEndpoint = (MockEndpoint)this.context.getEndpoint("mock:azure-consumed", MockEndpoint.class);
        return mockEndpoint.getReceivedExchanges().stream().map(Exchange::getMessage).map(m -> (String)m.getBody(String.class)).collect(Collectors.toList());
    }

    @Path(value="/send-events")
    @POST
    @Produces(value={"text/plain"})
    @Consumes(value={"text/plain"})
    public Response sendEvents(String body) throws Exception {
        this.message = body;
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }
}

